﻿// CYPAC basic application framework
// 2000/09/06 by T.Kudou <kudou@cypac.co.jp>
// $Id$

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ccc/app/Application.h>
#include <ccc/base/base.h>

CCC_NAMESPACE_START(CCC);

Application::Application()
{
  argc = 0;
  argv = 0;
  Ccc::initialize();
}

Application::Application(int _argc, char** _argv)
{
  argc = _argc;
  argv = _argv;
  Ccc::initialize();
}

Application::~Application()
{
  Ccc::unInitialize();
}

AppArg*
Application::getAppArg()
{
  static AppArg args[] =
  {
    { "--version", 1 },		// 1: show version
    { "-V", 1 },		// 1: show version
    { "-h", 2 },		// 2: help
    { "-help", 2 },		// 2: help
    { "--help", 2 },		// 2: help
    { 0, 0  },
  };
  return args;
}

bool
Application::parseArgument()
{
  AppArg* args = getAppArg();
  int i;
  bool argument_ok_p = true;
  for (i = 1; i < argc; i++)
  {
    AppArg* p;
    int n = -1;
    size_t arg_len = strlen(argv[i]);
    char* eq_str = 0;
    for (p = args; p && !p->eofP(); p++)
    {
      size_t cmd_len = strlen(p->getOptionStr());
      if (arg_len == cmd_len)
      {
	if (strcmp(argv[i], p->getOptionStr()) == 0)
	{
	  n = p->getOptionNum();
	  break;
	}
      }
      else if (cmd_len + 2 <= arg_len)
      {
	if ((strncmp(argv[i], p->getOptionStr(), cmd_len) == 0) &&
	    (argv[i][cmd_len] == '='))
	{
	  n = p->getOptionNum();
	  eq_str = &argv[i][cmd_len + 1];
	  break;
	}
      }
    }
    argument_ok_p = checkArgument(n, i, eq_str);
    if (!argument_ok_p)
    {
      break;
    }
  }
  return argument_ok_p;
}

bool
Application::checkArgument(int n, int& i, char* eq_str)
{
  bool opt_used_p = false;
  if (eq_str)
  {
    return checkArgument(n, argv[i], eq_str, opt_used_p);
  }
  else if (i + 1 < argc)
  {
    bool ret = checkArgument(n, argv[i], argv[i + 1], opt_used_p);
    if (opt_used_p)
    {
      i++;
    }
    return ret;
  }
  else
  {
    return checkArgument(n, argv[i], 0, opt_used_p);
  }
}

bool
Application::checkArgument(int n, char* arg, char* opt, bool& opt_used_p)
{
  return false;	// TODO:
}

bool
Application::initialize()
{
  bool argument_ok_p = parseArgument();
  if (argument_ok_p)
  {
    //printf("Application initialize.\n");
  }
  else
  {
    //printf("Application argument error.\n");
  }
  return argument_ok_p;
}

int
Application::run()
{
  try
  {
    // main process
    //printf("Application run.\n");
    exit(1);
  }
  catch (int i)
  {
    // caught exit
    //printf("exit(%d)\n", i);
    return i;
  }
  return 0;
}

int
Application::unInitialize(int ret)
{
  //printf("Application clear away.\n");
  return ret;
}

void
Application::exit(int ret)
{
  throw((int)ret);
}

CCC_NAMESPACE_END(CCC);
