﻿// CYPAC basic application framework
// 2000/09/06 by T.Kudou <kudou@cypac.co.jp>
// $Id$

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ccc/app/ApplicationW.h>
#include <ccc/base/base.h>

CCC_NAMESPACE_START(CCC);

ApplicationW::ApplicationW()
{
  argc = 0;
  argv = 0;
  Ccc::initialize();
}

ApplicationW::ApplicationW(int _argc, wchar_t** _argv)
{
  argc = _argc;
  argv = _argv;
  Ccc::initialize();
}

ApplicationW::~ApplicationW()
{
  Ccc::unInitialize();
}

AppArgW*
ApplicationW::getAppArg()
{
  static AppArgW args[] =
  {
#if 1
	  { L"--version", 1 },	// 1: show version
      { L"-V", 1 },			// 1: show version
      { L"-h",  2 },		// 2: help
      { L"-help", 2 },		// 2: help
      { L"--help", 2 },		// 2: help
#else  /* Windows CEで使用するかもしれないコード */
	  { { '-', '-', 'v', 'e', 'r', 's', 'i', 'o', 'n', 0 }, 1 }, // 1: show version
	  { { '-', 'V', 0 }, 1 },									 // 1: show version
	  { { '-', 'h', 0 },  2 },									// 2: help
      { { '-', 'h', 'e', 'l', 'p', 0 }, 2 },					// 2: help
      { { '-', '-', 'h', 'e', 'l', 'p', 0 }, 2 },               // 2: help
#endif
    { 0, 0  },
  };
  return args;
}

bool
ApplicationW::parseArgument()
{
  AppArgW* args = getAppArg();
  int i;
  bool argument_ok_p = true;
  for (i = 1; i < argc; i++)
  {
    AppArgW* p;
    int n = -1;
    size_t arg_len = wcslen(argv[i]);
    wchar_t* eq_str = 0;
    for (p = args; p && !p->eofP(); p++)
    {
      size_t cmd_len = wcslen(p->getOptionStr());
      if (arg_len == cmd_len)
      {
	if (wcscmp(argv[i], p->getOptionStr()) == 0)
	{
	  n = p->getOptionNum();
	  break;
	}
      }
      else if (cmd_len + 2 <= arg_len)
      {
	if ((wcsncmp(argv[i], p->getOptionStr(), cmd_len) == 0) &&
	    (argv[i][cmd_len] == '='))
	{
	  n = p->getOptionNum();
	  eq_str = &argv[i][cmd_len + 1];
	  break;
	}
      }
    }
    argument_ok_p = checkArgument(n, i, eq_str);
    if (!argument_ok_p)
    {
      break;
    }
  }
  return argument_ok_p;
}

bool
ApplicationW::checkArgument(int n, int& i, wchar_t* eq_str)
{
  if (eq_str)
  {
    return false;
  }
  return checkArgument(n, i);
}

bool
ApplicationW::checkArgument(int n, int& i)
{
  // sample
  bool argument_ok_p = true;
  switch (n)
  {
   case 1:
    //printf("version\n");
    break;
   case 2:
    //printf("help\n");
    break;
   default:
    //printf("unknown option:%s\n", argv[i]);
    argument_ok_p = false;
    break;
  }
  return argument_ok_p;
}

bool
ApplicationW::initialize()
{
  bool argument_ok_p = parseArgument();
  if (argument_ok_p)
  {
    //printf("ApplicationW initialize.\n");
  }
  else
  {
    //printf("ApplicationW argument error.\n");
  }
  return argument_ok_p;
}

int
ApplicationW::run()
{
  try
  {
    // main process
    //printf("ApplicationW run.\n");
    exit(1);
  }
  catch (int i)
  {
    // caught exit
    //printf("exit(%d)\n", i);
    return i;
  }
  return 0;
}

int
ApplicationW::unInitialize(int ret)
{
  //printf("ApplicationW clear away.\n");
  return ret;
}

void
ApplicationW::exit(int ret)
{
  throw((int)ret);
}

CCC_NAMESPACE_END(CCC);
