﻿// $Id$
// Copyright (C) 1992, 1993, 1994, 1999 by T.Kudou. All rights reserved.
// Copyright (C) 2000 CYPAC Co.,Inc. All rights reserved.

#include <stdlib.h>

#ifdef __BORLANDC__
#include <mem.h>
#endif /* _BORLANDC_ */

//#define ALLOCATOR_DEBUG

#ifdef ALLOCATOR_DEBUG
#include <stdio.h>
#endif

#include <string.h>
#include <assert.h>
#include <ccc/base/Allocator.h>

CCC_NAMESPACE_START(CCC);

#ifdef ALLOCATOR_DEBUG
struct AllocatorDebug
{
  const static int magic_value = 0x12345678;
  static int serial;

  int magic_number;
  int dummy1[4];
  int serial_number;
  int dummy2[4];

  void set(int serial)
  {
    serial_number = serial;
    magic_number = magic_value;
  }
  bool validP()
  {
    return magic_number == magic_value;
  }
  static int getSerial() { return serial++; }
};

int AllocatorDebug::serial = 0;
#endif

Allocator::Allocator(Size size)
{
  if (size == 0)
  {
    size = 1;
  }
  Allocator::size = size;
#ifndef ALLOCATOR_DEBUG
  mem = malloc(size);
#else /* ALLOCATOR_DEBUG */
  void* p = malloc(size + sizeof(AllocatorDebug) * 2);
  mem = (void*)((char*)p + sizeof(AllocatorDebug));
  AllocatorDebug* ad1 = (AllocatorDebug*)p;
  AllocatorDebug* ad2 = (AllocatorDebug*)((void*)((char*)mem + size));
  int n = AllocatorDebug::getSerial();
  ad1->set(n);
  ad2->set(n);
#endif /* ALLOCATOR_DEBUG */
  assert(mem != 0);
  used_size = 0;
}

Allocator::Allocator(Allocator& m)
{
#ifndef ALLOCATOR_DEBUG
  size = m.size;
  mem = malloc(size);
#else /* ALLOCATOR_DEBUG */
  size = m.size;
  void* p = malloc(size + sizeof(AllocatorDebug) * 2);
  mem = (void*)((char*)p + sizeof(AllocatorDebug));
  AllocatorDebug* ad1 = (AllocatorDebug*)p;
  AllocatorDebug* ad2 = (AllocatorDebug*)((void*)((char*)mem + size));
  int n = AllocatorDebug::getSerial();
  ad1->set(n);
  ad2->set(n);
#endif /* ALLOCATOR_DEBUG */
  assert(mem != 0);
  memcpy(mem, m.mem, size);
  used_size = m.used_size;
}

Allocator::~Allocator()
{
  if (mem != 0)
  {
#ifndef ALLOCATOR_DEBUG
    free(mem);
#else /* ALLOCATOR_DEBUG */
    AllocatorDebug* ad1 = (AllocatorDebug*)((void*)((char*)mem - sizeof(AllocatorDebug)));
    AllocatorDebug* ad2 = (AllocatorDebug*)((void*)((char*)mem + size));
    if (!ad1->validP() || !ad2->validP())
    {
      fprintf(stderr, "Allocator ERROR: memory magic number error at address %x. serial:%d-%d magic:%x-%x. free() aborted!\n",
	      mem,
	      ad1->serial_number, ad2->serial_number,
	      ad1->magic_number, ad2->magic_number);
    }
    else
    {
      free((void*)ad1);
    }
#endif /* ALLOCATOR_DEBUG */
  }
}

void
Allocator::expand(Size size_)
{
  if (size >= size_)
  {
    return;
  }
  if (size_ == 0)
  {
    size_ = 1;
  }
#ifndef ALLOCATOR_DEBUG
  mem = realloc(mem, size_);
#else /* ALLOCATOR_DEBUG */
  AllocatorDebug* ad1 = (AllocatorDebug*)((void*)((char*)mem - sizeof(AllocatorDebug)));
  AllocatorDebug* ad2 = (AllocatorDebug*)((void*)((char*)mem + size));
  if (!ad1->validP() || !ad2->validP())
  {
    fprintf(stderr, "Allocator ERROR: memory magic number error at address %x. serial:%d-%d magic:%x-%x. realloc() aborted!\n",
	    mem,
	    ad1->serial_number, ad2->serial_number,
	    ad1->magic_number, ad2->magic_number);
  }
  else
  {
    AllocatorDebug ad = *ad1;
    void* p = realloc((void*)ad1, size_ + sizeof(AllocatorDebug) * 2);
    mem = (void*)((char*)p + sizeof(AllocatorDebug));
    ad1 = (AllocatorDebug*)p;
    AllocatorDebug* ad2 = (AllocatorDebug*)((void*)((char*)mem + size_));
    *ad1 = ad;
    *ad2 = ad;
  }
#endif /* ALLOCATOR_DEBUG */
  assert(mem != 0);
  Allocator::size = size_;
}

void
Allocator::shrink(Size /*size*/)
{
  ; // do nothing now
}

void
Allocator::setUsedSize(Size n)
{
  expand(n);
  used_size = n;
}

Size
Allocator::addUsedSize(Size add_size)
{
  setUsedSize(used_size + add_size);
  return used_size;
}

CCC_NAMESPACE_END(CCC);

