﻿// $Id$
// Copyright (C) 1992, 1993, 1994, 1999 by T.Kudou. All rights reserved.
// Copyright (C) 2000 CYPAC Co.,Inc. All rights reserved.

#include <stdlib.h>

#ifdef __BORLANDC__
#include <mem.h>
#endif /* _BORLANDC_ */

#include <string.h>
#include <ccc/base/ArrayList.h>

CCC_NAMESPACE_START(CCC);

// ------------------------------------------------------------------------ 
// class InnerArrayList

void
InnerArrayList::checkBufferSize(Size new_size)
{
  new_size++;   // for the sentinel
  if (new_size > buffer_size)
  {
    buffer = (void* (*)[])realloc(
#ifdef CHAR_P_MALLOC_T
				   (char*)buffer,
#else
				   buffer, 
#endif
                  (size_t) (sizeof(void*) * (new_size + extra_realloc_size)));
    buffer_size = new_size + extra_realloc_size;
  }
}

InnerArrayList::InnerArrayList()
{
  buffer = (void* (*)[])malloc(sizeof(void*) * default_initial_buffer_size);
  buffer_size = default_initial_buffer_size;
  used_size = 0;
}

InnerArrayList::InnerArrayList(Size initial_buffer_size)
{
  initial_buffer_size++;	// for the sentinel
  buffer = (void* (*)[])malloc(sizeof(void*) * initial_buffer_size);
  buffer_size = initial_buffer_size;
  used_size = 0;
}

InnerArrayList::~InnerArrayList()
{
#ifdef CHAR_P_MALLOC_T
  free((char*)buffer);
#else
  free((void*)buffer);
#endif
}

void
InnerArrayList::assign(InnerArrayList& l)
{
  clear();
  checkBufferSize(l.used_size);
  memcpy(buffer, l.buffer, sizeof(void*) * l.used_size);
  used_size = l.used_size;
}

bool
InnerArrayList::emptyP() const
{
  return used_size == 0;
}

Size
InnerArrayList::number() const
{
  return used_size;
}

void
InnerArrayList::clear()
{
  used_size = 0;
}

void*
InnerArrayList::vector(Size n) const
{
  // 0 <= n < used_size
  return (n >= used_size) ? 0 : (*buffer)[n];
}

Size
InnerArrayList::getPosition(void* element) const
{
  (*buffer)[used_size] = element;
  Size n;
  for (n = 0; (*buffer)[n] != element; n ++)
  {
    ;
  }
  return (n == used_size) ? 0 : n + 1;
}

void*
InnerArrayList::prev(void* element) const
{
  (*buffer)[used_size] = element;
  Size n;
  for (n = 0; (*buffer)[n] != element; n ++)
  {
    ;
  }
  return ((n == used_size) || (n == 0)) ? 0 : (*buffer)[n - 1];
}

void*
InnerArrayList::next(void* element) const
{
  (*buffer)[used_size] = element;
  Size n;
  for (n = 0; (*buffer)[n] != element; n++)
  {
    ;
  }
  return n >= used_size - 1 ? 0 : (*buffer)[n + 1];
}

void*
InnerArrayList::head() const
{
  return used_size == 0 ? 0 : (*buffer)[0];
}

void*
InnerArrayList::tail() const
{
  return used_size == 0 ? 0 : (*buffer)[used_size - 1];
}

bool
InnerArrayList::elementP(void* element) const
{
  (*buffer)[used_size] = element;
  Size n;
  for (n = 0; (*buffer)[n] != element; n ++)
  {
    ;
  }
  return !((n == used_size) || (n == 0));
}

void
InnerArrayList::push(void* element)
{
  checkBufferSize(used_size + 1);
  memmove(& (*buffer)[1], & (*buffer)[0], sizeof(void*) * used_size);
  (*buffer)[0] = element;
  used_size++;
}

void*
InnerArrayList::pop()
{
  if (used_size == 0)
  {
    return 0;
  }
  void* ret = (*buffer)[0];
  used_size--;
  memmove(& (*buffer)[0], & (*buffer)[1], sizeof(void*) * used_size);
  return ret;
}

void
InnerArrayList::inject(void* element)
{
  checkBufferSize(used_size + 1);
  (*buffer)[used_size++] = element;
}

void*
InnerArrayList::eject()
{
  if (used_size == 0)
  {
    return 0;
  }
  return(*buffer)[--used_size];
}

bool
InnerArrayList::insertBefore(Size pos, void* element)
{
  if (!validPositionP(pos))
  {
    return false;
  }
  checkBufferSize(used_size + 1);
  memmove(& (*buffer)[pos], & (*buffer)[pos - 1], 
           sizeof(void*) * ((used_size + 1) - pos));
  (*buffer)[pos - 1] = element;
  used_size++;
  return true;
}

bool
InnerArrayList::insertBefore(void* pos, void* element)
{
  (*buffer)[used_size] = element;
  Size n;
  for (n = 0; (*buffer)[n] != pos; n++)
  {
    ;
  }
  if (n >= used_size)
  {
    return false;
  }
  checkBufferSize(used_size + 1);
  memmove(& (*buffer)[n + 1], & (*buffer)[n], 
           sizeof(void*) * (used_size - n));
  (*buffer)[n] = element;
  used_size++;
  return true;
}

bool
InnerArrayList::insertAfter(Size pos, void* element)
{
  if (pos > used_size)
  {
    return false;
  }
  checkBufferSize(used_size + 1);
  memmove(& (*buffer)[pos + 1], & (*buffer)[pos], 
           sizeof(void*) * (used_size - pos));
  (*buffer)[pos] = element;
  used_size++;
  return true;
}

bool
InnerArrayList::insertAfter(void* pos, void* element)
{
  (*buffer)[used_size] = element;
  Size n;
  for (n = 0; (*buffer)[n] != pos; n++)
  {
    ;
  }
  if (n >= used_size)
  {
    return false;
  }
  checkBufferSize(used_size + 1);
  memmove(& (*buffer)[n + 2], & (*buffer)[n + 1], 
           sizeof(void*) * (used_size - (n + 1)));
  (*buffer)[n + 1] = element;
  used_size++;
  return true;
}

bool
InnerArrayList::remove(void* pos)
{
  (*buffer)[used_size] = pos;
  Size n;
  for (n = 0; (*buffer)[n] != pos; n++)
  {
    ;
  }
  if (n < used_size)
  {
    memmove(& (*buffer)[n], & (*buffer)[n + 1], 
	     sizeof(void*) * (used_size - n - 1));
    used_size--;
    return true;
  }
  return false;
}

bool
InnerArrayList::remove(Size pos)
{
  if (!validPositionP(pos))
  {
    return false;
  }
  memmove(& (*buffer)[pos - 1], & (*buffer)[pos], 
	  sizeof(void*) * (used_size - pos));
  used_size--;
  return true;
}

bool
InnerArrayList::exchangeElement(Size pos, void* element)
{
  if (!validPositionP(pos))
  {
    return false;
  }
  (*buffer)[pos - 1] = element;
  return true;
}

bool
InnerArrayList::exchangeElement(void* pos, void* element)
{
  (*buffer)[used_size] = pos;
  Size n;
  for (n = 0; (*buffer)[n] != pos; n++)
  {
    ;
  }
  if (n < used_size)
  {
    (*buffer)[n] = element;
    return true;
  }
  return false;
}

bool
InnerArrayList::swapElement(void* i1, void* i2)
{
  (*buffer)[used_size] = i1;
  Size n1;
  for (n1 = 0; (*buffer)[n1] != i1; n1++)
  {
    ;
  }
  (*buffer)[used_size] = i2;
  Size n2;
  for (n2 = 0; (*buffer)[n2] != i2; n2++)
  {
    ;
  }
  if ((n1 < used_size) && (n2 < used_size))
  {
    void* swap_buf = (*buffer)[n1];
    (*buffer)[n1] = (*buffer)[n2];
    (*buffer)[n2] = swap_buf;
    return true;
  }
  return false;
}

bool
InnerArrayList::swapElement(Size n1, Size n2)
{
  if (!validPositionP(n1) || !validPositionP(n2))
  {
    return false;
  }
  void* swap_buf = (*buffer)[n1 - 1];
  (*buffer)[n1 - 1] = (*buffer)[n2 -1];
  (*buffer)[n2 - 1] = swap_buf;
  return true;
}

bool
InnerArrayList::removeAllBefore(Size pos)
{
  if ((pos == 0) ||
      (pos > used_size))
  {
    return false;
  }
  else
  {
    //           +- pos
    //           v
    // [1][2][3][4][5]  used_size = 5
    memmove(&(*buffer)[0], &(*buffer)[pos - 1], (used_size - pos + 1) * sizeof(void*));
    used_size -= (pos - 1);
  }
  return true;
}

bool
InnerArrayList::removeAllBefore(void* pos)
{
  Size pos_n = getPosition(pos);
  if (!pos_n)
  {
    return false;
  }
  return removeAllBefore(pos_n);
}

bool
InnerArrayList::removeAllAfter(Size pos)
{
  if (validPositionP(pos))
  {
    used_size = pos;
    return true;
  }
  return false;
}

bool
InnerArrayList::removeAllAfter(void* pos)
{
  Size pos_n = getPosition(pos);
  if (!pos_n)
  {
    return false;
  }
  return removeAllAfter(pos_n);
}

bool
InnerArrayList::removeAllBetween(Size pos1, Size pos2)
{
  Size n1 = getMin(pos1, pos2);
  Size n2 = getMax(pos1, pos2);
  if (!validPositionP(n1) || !validPositionP(n2))
  {
    return false;
  }
  memmove(&(*buffer)[n1 - 1], &(*buffer)[n2], (used_size - n2) * sizeof(void*));
  used_size = n1 - 1 + used_size - n2;
  return true;
}

bool
InnerArrayList::removeAllBetween(void* pos1, void* pos2)
{
  Size pos_n1 = getPosition(pos1);
  Size pos_n2 = getPosition(pos2);
  if (!pos_n1 || !pos_n2)
  {
    return false;
  }
  return removeAllBetween(pos_n1, pos_n2);
}

void**
InnerArrayList::getArrayBuffer()
{
  return (void**)buffer;
}

// ------------------------------------------------------------------------
// class InnerArrayListIterator

InnerArrayListIterator::InnerArrayListIterator(const InnerArrayList* l_)
 : InnerIterator(l_)
{
  pos = 1;
}
    
void*
InnerArrayListIterator::current() const
{
  if (!validPositionP())
  {
    return 0;
  }
  return ((InnerArrayList*)getInnerList())->vector(pos - 1);
}

void*
InnerArrayListIterator::next()
{
  return ((InnerArrayList*)getInnerList())->vector(pos++ - 1);
}

void*
InnerArrayListIterator::prev()
{
  void* ret = 0;
  if (pos)
  {
    ret = ((InnerArrayList*)getInnerList())->vector(pos - 1);
    pos--;
  }
  return ret;
}

void*
InnerArrayListIterator::rewind()
{
  pos = 1;
  return ((InnerArrayList*)getInnerList())->vector(pos - 1);
}

void*
InnerArrayListIterator::unwind()
{
  pos = ((InnerArrayList*)getInnerList())->number();
  return ((InnerArrayList*)getInnerList())->vector(pos - 1);
}

bool
InnerArrayListIterator::validPositionP() const
{
  return (1 <= pos && pos <= ((InnerArrayList*)getInnerList())->number());
}

Size
InnerArrayListIterator::getPosition() const
{
  return pos;
}

CCC_NAMESPACE_END(CCC);
