﻿// $Id$

#ifndef INCLUDE_ccc_base_Bag_h
#define INCLUDE_ccc_base_Bag_h

#include <ccc/base/dic.h>

CCC_NAMESPACE_START(CCC)

template <class Element>
class Bag			//! Bag
  : public Collection<Element>
{
 private:
  CompareFunc compare;

 public:
  Bag() : compare(&pointerCompare) { }
  /*! コンストラクタ */
  Bag(CompareFunc compare_) : compare(compare_) { }
  virtual ~Bag() { }

  // Collection interface
  virtual bool emptyP() const = 0;
  virtual Size number() const = 0;
  virtual bool add(Element* element) = 0;
  virtual bool remove(Element* element) = 0;
  virtual void clear() = 0;

  // Bag interface
  virtual Size getElementCount(Element* element) const = 0;
  virtual Size decrimentElementCount(Element* element, Size n) = 0;
  virtual Size incrimentElementCount(Element* element, Size n) = 0;
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_Bag_h */
