﻿// $Id$

#include <assert.h>
#include <ccc/base/BitString.h>

CCC_NAMESPACE_START(CCC);

const UInt32 unit = 32;

UInt32 
BitString::getBufferSize()
{
  return size / unit + 1;
}

BitString::BitString(UInt32 size)
{
  BitString::size = size;
  UInt32 buf_size = (UInt32)getBufferSize();
  buf = new UInt32[buf_size];
  // 0 clear
  for (UInt32 i = 0; i < buf_size; i++) 
  {
    buf[i] = 0L;
  }
}

BitString::~BitString()
{
  delete buf;
}

static UInt32 mask_table[32] = 
{
  0x00000001L, 0x00000002L, 0x00000004L, 0x00000008L,
  0x00000010L, 0x00000020L, 0x00000040L, 0x00000080L,
  0x00000100L, 0x00000200L, 0x00000400L, 0x00000800L,
  0x00001000L, 0x00002000L, 0x00004000L, 0x00008000L,
  0x00010000L, 0x00020000L, 0x00040000L, 0x00080000L,
  0x00100000L, 0x00200000L, 0x00400000L, 0x00800000L,
  0x01000000L, 0x02000000L, 0x04000000L, 0x08000000L,
  0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L,
};

bool 
BitString::get(UInt32 n)
{
  if (n >= size)
  {
    return false;
  }
  return (mask_table[n % unit] & buf[n / unit]) != 0L;
}

UInt32 
BitString::getLeastClearBit()
{
  UInt32 bufsize = getBufferSize();
  for (UInt32 n = 0; n < bufsize; n++) 
  {
    if (buf[ (UInt32)n] != 0xffffffffL) 
    {
      for (UInt32 i = 0; i < 32L; i++)
      {
	if (!get(i + n * 32L))
	{
	  return i + n * 32L;
	}
      }
      assert(false);
    }
  }
  return size;
}

UInt32 
BitString::getLeastSetBit()
{
  UInt32 bufsize = getBufferSize();
  for (UInt32 n = 0; n < bufsize; n++) 
  {
    if (buf[ (UInt32)n] != 0x0L) 
    {
      for (UInt32 i = 0; i < 32L; i++)
      {
	if (get(i + n * 32L))
	{
	  return i + n * 32L;
	}
      }
      assert(false);
    }
  }
  return size;
}

void 
BitString::set(UInt32 n, bool b)
{
  if (n >= size)
  {
    return;
  }
  if (b == false) 
  {
    // bit clear
    buf[n / unit] &= ~mask_table[n % unit];
  }
  else 
  {
    // bit set
    buf[n / unit] |= mask_table[n % unit];
  }
}

void 
BitString::setAll(bool b)
{
  UInt32 pattern = (b == false) ? 0 : 0xffffffffL;
  UInt32 bufsize = getBufferSize();
  for (UInt32 n = 0; n < bufsize; n++) 
  {
    buf[n] = pattern;
  }
}

CCC_NAMESPACE_END(CCC);
