﻿// $Id$

#ifndef INCLUDE_ccc_base_BitString_h
#define INCLUDE_ccc_base_BitString_h

#include <ccc/base/base.h>
#include <stddef.h>

CCC_NAMESPACE_START(CCC)

/*!
 * ビット列を表現するクラスです。
 */
class BitString
{
  /*!
   * ビット列のサイズを示します。
   */
  UInt32 size;
  /*!
   * ビット列を示すためのバッファ
   */
  UInt32* buf;
  /*!
   * バッファサイズを計算します。
   * \return バッファサイズ
   */
  UInt32 getBufferSize();
public:
  /*!
   * コンストラクタ
   * 初期状態では全てのビットがfalseにセットされます。
   * \param size ビット列のサイズ
   */
  BitString(UInt32 size);
  /*!
   * デストラクタ
   */
  ~BitString();
  /*!
   * 特定の位置のビットの値を調べます。
   * \param n 位置(0 <= n < size)
   * \return ビットの値
   */
  bool get(UInt32 n);
  /*!
   * 特定の位置のビットの値を調べます。
   * \param n 位置(0 <= n < size)
   * \return ビットの値
   */
  bool operator [] (UInt32 n) { return get(n); }
  /*!
   * 特定の位置のビットをセットします。
   * \param n 位置(0 <= n < size)
   * \param b セットする値
   */
  void set(UInt32 n, bool b);
  /*!
   * 全てのビットをセットします。
   * \param b セットする値
   */
  void setAll(bool b);
  /*!
   * ビット列のサイズを取得します。
   * \return サイズ
   */
  UInt32 getSize() { return size; }
  /*!
   * 最小のfalseにクリアされているビット位置を求めます。
   * \return ビット位置, 全てtrueの場合にはsizeの値が返ります。
   */
  UInt32 getLeastClearBit();
  /*!
   * 最小のtrueにセットされているビット位置を求めます。
   * \return ビット位置, 全てfalseの場合にはsizeの値が返ります。
   */
  UInt32 getLeastSetBit();
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_BitString_h */
