﻿// $Id$

#ifdef HANDLER_DEBUG
#  include <stdio.h>
#endif /* HANDLER_DEBUG */

#include <ccc/base/base.h>
#include <ccc/base/TextReader.h>
#include <ccc/base/TextWriter.h>
#include <ccc/base/NullOFlow.h>

CCC_NAMESPACE_START(CCC);

static bool initialize_p = false;
static bool un_initialize_p = false;
static bool (*initialize_handler[CM_NUMBER])(bool initialize_p);

#ifdef HANDLER_DEBUG
static const char* handler_name_table[] = { "CM_BASE", "CM_FILE", "CM_APP", "CM_ICEMAN", "CM_FETCH", "CM_POSIX", "CM_XML", };
#endif /* HANDLER_DEBUG */

bool
Ccc::initialize()
{
  if (!initialize_p)
  {
    int i;
    for (i = 0; i < CM_NUMBER; i++)
    {
      if (*initialize_handler[i] != 0)
      {
#ifdef HANDLER_DEBUG
	printf("hander:%s will be called.\n", handler_name_table[i]);
#endif /* HANDLER_DEBUG */
	bool p = (*initialize_handler[i])(true);
	if (!p)
	{
	  return false;
	}
      }
#ifdef HANDLER_DEBUG
      else
      {
	printf("hander:%s is not set.\n", handler_name_table[i]);
      }
#endif /* HANDLER_DEBUG */
    }
    initialize_p = true;
  }
  return true;
}

bool
Ccc::unInitialize()
{
  if (!initialize_p)
  {
    return false;
  }
  if (!un_initialize_p)
  {
    int i;
    for (i = 0; i < CM_NUMBER; i++)
    {
      if (*initialize_handler[i] != 0)
      {
	bool p = (*initialize_handler[i])(false);
	if (!p)
	{
	  return false;
	}
      }
    }
    un_initialize_p = true;
  }
  return true;
}

int
Ccc::setInitializeHandler(CccModule cm, bool (*handler)(bool initialize_p))
{
#ifdef HANDLER_DEBUG
  printf("hander:%s is set.\n", handler_name_table[cm]);
#endif /* HANDLER_DEBUG */
  initialize_handler[cm] = handler;
  return 1234;	// dummy
}

// for ccc/base initialization

static bool
initializeBase(bool init_p)
{
  if (init_p)
  {
    nulout_flow = new NullOFlow(IOTYPE_ANY);
    nulout_w8 = new TextWriter<Int8>(nulout_flow);
    nulout_w16 = new TextWriter<UInt16>(nulout_flow);
    nulout_w32 = new TextWriter<UInt32>(nulout_flow);
  }
  else
  {
    delete nulout_w8;
    delete nulout_w16;
    delete nulout_w32;
    delete nulout_flow;
  }
  return true;
}

static int initialize_base_dummy = Ccc::setInitializeHandler(CM_BASE, &initializeBase);

CCC_NAMESPACE_END(CCC);
