﻿// $Id$

#ifndef INCLUDE_ccc_base_Ccc_h
#define INCLUDE_ccc_base_Ccc_h

#include <ccc/base/base.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * cccのモジュールを示します。
 * \ja_end
 */
enum CccModule
{
  CM_BASE,	//!< ccc/base
  CM_FILE,	//!< ccc/file
  CM_APP,	//!< ccc/app
  CM_ICEMAN,	//!< ccc/iceman
  CM_FETCH,	//!< ccc/fetch
  CM_POSIX,	//!< ccc/posix
  CM_XML,	//!< ccc/xml
  // 
  CM_NUMBER,	//!< number of ccc modules
};

/*!
 * \ja
 * cccライブラリ全体の初期化、終了処理を行なうクラスです。
 * \ja_end
 */
class Ccc
{
 public:
  /*!
   * \ja
   * cccライブラリの初期化を行ないます。
   * リンクしたcccライブラリのサブモジュールの初期化が行なわれます。
   * \retval true 正常に初期化が行なわれました。
   * \retval false 初期化に失敗しました。
   * \ja_end
   */
  static bool initialize();
  /*!
   * \ja
   * cccライブラリの終了処理を行ないます。
   * リンクしたcccライブラリのサブモジュールの終了処理が行なわれます。
   * \retval true 正常に終了処理が行なわれました。
   * \retval false 終了処理に失敗しました。
   * \ja_end
   */
  static bool unInitialize();
  /*!
   * \ja
   * 初期化、終了処理用のハンドラを設定します。
   * cccライブラリ内部でのみ使用します。
   * ハンドラはbool (*handler)(bool initialize_p)の形式とします。
   * 初期化時にはinitialize_pにtrueが渡され、終了処理時にはfalseが
   * 渡されます。ハンドラの返り値は、処理に成功した時にtrue、失敗した
   * 時にfalseとなります。
   * \param cm モジュール識別子
   * \param handler 登録する初期化、終了処理用の関数
   * \return ダミー値
   * \ja_end
   */
  static int setInitializeHandler(CccModule cm, bool (*handler)(bool initialize_p));
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_Ccc_h */
