﻿// $Id$

#ifndef INCLUDE_ccc_base_Collection_h
#define INCLUDE_ccc_base_Collection_h

/*!
 * \file Collection.h
 * \ja
 * このファイルはCollectionインターフェースを定義しています。
 * \ja_end
 * \en
 * This file defines the Collection interface.
 * \en_end
 */

#include <ccc/base/base.h>
#include <ccc/base/Iterator.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * Collectionクラスは集合を表現します。
 * Collectionクラスは実装を持たない仮想インターフェースです。
 * このクラスで定義されたメソッドは継承されたクラスで実装されています。
 * \ja_end
 * \en
 * The Collection class expresses the set.
 * The Collection class is a virtual interface without implementations.
 * The methods defined in this class are implemented in derived classes.
 * \en_end
 */
template <class Element>
class Collection
  : public Object
{
 public:
  /*!
   * \ja
   * コンストラクタ
   * \ja_end
   * \en
   * constructor
   * \en_end
   */
  Collection() { }
  /*!
   * \ja
   * デストラクタ
   * \ja_end
   * \en
   * destructor
   * \en_end
   */
  virtual ~Collection() { }

  /* Collection interface */

  /*!
   * \ja
   * Collectionが空かどうかを調べます。
   * \retval true 空
   * \retval false 集合の中に要素がある
   * \ja_end
   * \en
   * This method checks whether this collection is empty or not.
   * \retval true, It is empty.
   * \retval false, It isn't empty.
   * \en_end
   */
  virtual bool emptyP() const = 0;
  /*!
   * \ja
   * このCollectionで管理されている要素を数えます。
   * \return 要素数
   * \ja_end
   * \en
   * This method counts the number of the elements managed by this collection.
   * \return The number of the elements.
   * \en_end
   */
  virtual Size number() const = 0;
  /*!
   * \ja
   * Collectionに一つの要素を追加します。
   * \param element 追加する要素 
   * \ja_end
   * \en
   * This method adds an element into this collection.
   * \param element, An adding element.
   * \en_end
   */
  virtual bool add(Element* element) = 0;
  /*!
   * \ja
   * Collectionから一つの要素を削除します。
   * \param element 削除する要素
   * \ja_end
   * \en
   * This method removes an element from this collection.
   * \param element, A removing element.
   * \en_end
   */
  virtual bool remove(Element* element) = 0;
  /*!
   * \ja
   * Collectionを空にします。
   * \ja_end
   * \en
   * This method makes this collection empty.
   * \en_end
   */
  virtual void clear() = 0;
  /*!
   * \ja
   * Collectionの中に指定した要素が存在するかどうかを調べます。
   * \param element 存在を調べる要素
   * \return true 要素が存在した。
   * \return false 要素が存在しなかった。
   * \ja_end
   * \en
   * This method verifies whether a specified element exist in this collection.
   * \param element, a checking element.
   * \return true, The element exist in this collection.
   * \return false, The element doesn't exist in this collection. 
   * \en_end
   */
  virtual bool elementP(Element* element) const = 0;
  /*!
   * \ja
   * このクラス用のIteratorを生成します。
   * \return 生成されたIteratorオブジェクト
   * \ja_end
   * \en
   * This method creates an Iterator object of this class.
   * \return A created Iterator object.
   * \en_end
   */
  virtual Iterator<Element>* createIterator() const = 0;
};

template <class Element>
Itr<Element>::Itr(Collection<Element>* col)
{
  itr = col->createIterator();
}

template <class Element>
Itr<Element>::Itr(Collection<Element>& col)
{
  itr = col.createIterator();
}

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_Collection_h */
