﻿// $Id$

#include <ccc/base/CompositIFilter.h>

CCC_NAMESPACE_START(CCC)

CompositIFilter::CompositIFilter(IOType my_io_type, IOType src_io_type, IFlow* src)
  : IFilter(my_io_type, src_io_type, src)
{
}

CompositIFilter::~CompositIFilter()
{
  deleteIFilters();
}

#if 0
Iterator<IFilter>*
CompositIFilter::createIterator()
{
  Iterator<IFilter>* itr = list.createIterator();
  return itr;
}
#endif

void
CompositIFilter::deleteIFilters()
{
  IFilter* ifilter;
  while ((ifilter = list.pop()))
  {
    delete ifilter;
  }
}

void 
CompositIFilter::setSrc(IFlow* src)
{
  IFilter::setSrc(src);
  if (list.tail())
  {
    list.tail()->setSrc(src);
  }
}

void
CompositIFilter::add(IFilter* filter)
{
  if (!list.head())
  {
    filter->setSrc(getSrc());
  }
  else
  {
    filter->setSrc(list.head());
  }
  list.push(filter);
}

bool
CompositIFilter::rewind()
{
  if (!openedP())
  {
    return false;
  }
  Flow::rewind();
  if (!list.head())
  {
    return src->rewind();
  }
  bool ret = true;
  Iterator<IFilter>* itr = list.createIterator();
  IFilter* f;
  while ((f = itr->next()))
  {
    bool p = f->rewind();
    if (!p)
    {
      ret = false;
    }
  }
  delete itr;
  if (!getSrc()->rewind())
  {
    ret = false;
  }
  return ret;
}

IOType
CompositIFilter::getIOType()
{
  IFilter* head = list.head();
  if (head)
  {
    return head->getIOType();
  }
  return Flow::getIOType();
}

IOType
CompositIFilter::getSrcIOType()
{
  IFilter* tail = list.tail();
  if (tail)
  {
    return tail->getSrcIOType();
  }
  return IFilter::getSrcIOType();
}

bool
CompositIFilter::validCombinationP()
{
  if (!openedP())
  {
    return false;
  }
  IFilter* head = list.head();
  if (!head)
  {
    if (getSrcCombinationIOType() == IOTYPE_NULL)
    {
      return false;
    }
    if (!src)
    {
      return false;
    }
    return src->validCombinationP();
  }
  else
  {
    return head->validCombinationP();
  }
}

void
CompositIFilter::moveIFilters(CompositIFilter* to)
{
  IFilter* f = list.eject();
  while (f)
  {
    to->add(f);
  }
}

Int8
CompositIFilter::getInt8() CCC_RAISES(IOException)
{
  if (!openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_SRC);
  }
  Int8 ret = 0;
  if (list.head())
  {
    ret = list.head()->getInt8();
  }
  else
  {
    ret = getSrc()->getInt8();
  }
  setTopP(false);
  return ret;
}

UInt16
CompositIFilter::getUInt16() CCC_RAISES(IOException)
{
  if (!openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_SRC);
  }
  UInt16 ret = 0;
  if (list.head())
  {
    ret = list.head()->getUInt16();
  }
  else
  {
    ret = getSrc()->getUInt16();
  }
  setTopP(false);
  return ret;
}

UInt32
CompositIFilter::getUInt32() CCC_RAISES(IOException)
{
  if (!openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_SRC);
  }
  UInt32 ret = 0;
  if (list.head())
  {
    ret = list.head()->getUInt32();
  }
  else
  {
    ret = getSrc()->getUInt32();
  }
  setTopP(false);
  return ret;
}

CCC_NAMESPACE_END(CCC)
