﻿// $Id$

#ifndef INCLUDE_ccc_base_CompositIFilter_h
#define INCLUDE_ccc_base_CompositIFilter_h

#include <ccc/base/IFilter.h>
#include <ccc/base/LinkList.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * 複数のIFilterを順番にフィルタリングする複合IFilterを実現するクラスです。
 * \ja_end
 */
class CompositIFilter
  : public IFilter
{
 protected:
  LinkList<IFilter> list;

 public:
  /*!
   * \ja
   * コンストラクタ<br>
   * my_io_typeとsrc_io_typeはフィルタが追加されない場合に適応される型です。
   * フィルタが追加された場合には、getIOType(), getSrcIOType()の返す値は、
   * 追加されたフィルタに従い動的に決定されます。
   * \param my_io_type このフィルタの出力がサポートする型
   * \param src_io_type フィルタの入力がサポートする型
   * \param src フィルタ元IFlow
   * \ja_end
   */
  CompositIFilter(IOType my_io_type, IOType src_io_type, IFlow* src = 0);
  /*!
   * \ja
   * デストラクタ
   * \ja_end
   */
  virtual ~CompositIFilter();
  /*!
   * \ja
   * フィルタ元のIFlowをセットします。
   * \param src フィルタ元のIFlow
   * \ja_end
   */
  virtual void setSrc(IFlow* src);
  /*!
   * \ja
   * フィルタを追加します。
   * フィルタは追加した順番に実行されます。
   * 追加したフィルタは、デストラクタによってオブジェクトが破棄されません。
   * フィルタを破棄するには、createIterator()を利用してください。
   * \param filter 追加するフィルタ
   * \ja_end
   */
  virtual void add(IFilter* filter);
  /*!
   * \ja
   * Flowクラスのドキュメントを参照してください。
   * \ja_end
   */
  virtual bool rewind();
  /*!
   * \ja
   * Flowクラスのドキュメントを参照してください。
   * \ja_end
   */
  virtual IOType getIOType();
  /*!
   * \ja
   * IFlowクラスのドキュメントを参照してください。
   * \ja_end
   */
  virtual IOType getSrcIOType();
  /*!
   * \ja
   * フィルタ元とフィルタの入力が前提とする型が合致するかを
   * フィルタのチェーンを再帰的に調べます。
   * \retval true 合致する
   * \retval false 合致しない
   * \ja_end
   */
  virtual bool validCombinationP();
#if 0
  /*
   * NOTE:
   * デストラクタで登録されているIFilterを破棄するように
   * 仕様を変更したため、このメソッドは廃止しました。
   * このcreateIterator()メソッドを使用している箇所の
   * ソースコードは変更する必要があります。
   * 2006/1/21 Kudou
   */
  /*
   * \ja
   * 登録したIFilterのリストに対するイタレータを返します。
   * 登録フィルタのメモリを破棄する場合には、このイタレータを使って
   * 登録したフィルタのアドレスを取り出してdeleteしてください。
   * イタレータを使い終わったらdeleteにより削除してください。
   * \return イタレータ
   * \ja_end
   */
  //Iterator<IFilter>* createIterator();
#endif
  /*!
   * TODO: UNITTEST
   * \ja
   * このCompositIFilterに登録されているフィルタを外し、別の
   * CompositIFilterに移動する。
   * \param to 登録先のCompositIFilter
   * \ja_end
   */
  void moveIFilters(CompositIFilter* to);
  /*!
   * \ja
   * IFlowクラスのドキュメントを参照してください。
   * \ja_end
   */
  virtual Int8 getInt8() CCC_RAISES(IOException);
  /*!
   * \ja
   * IFlowクラスのドキュメントを参照してください。
   * \ja_end
   */
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  /*!
   * \ja
   * IFlowクラスのドキュメントを参照してください。
   * \ja_end
   */
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
 private:
  /*!
   * \ja
   * 登録したIFilterを破棄しIFilterのリストを空にします。
   * \ja_end
   */
  virtual void deleteIFilters();
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_CompositIFilter_h */
