﻿// $Id$

#include <assert.h>
#include <ccc/base/Conveyer.h>

CCC_NAMESPACE_START(CCC);

// ------------------------------------------------------------------------
// class Conveyer

Conveyer::Conveyer(IFlow* src_, OFlow* dest_)
  : src(src_), dest(dest_)
{
}

void
Conveyer::carry() CCC_RAISES(IOException)
{
  if (!src)
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_SRC);
  }
  if (!dest)
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_DEST);
  }
  try
  {
    int src_io_type = src->getIOType();
    int dest_io_type = dest->getIOType();
    if ((src_io_type & IOTYPE_INT8) &&
	(dest_io_type & IOTYPE_INT8))
    {
      Int8 c;
      for (;;)
      {
	c = src->getInt8();
	dest->putInt8(c);
      }
      assert(false);
    }
    else if ((src_io_type & IOTYPE_UINT16) &&
	     (dest_io_type & IOTYPE_UINT16))
    {
      UInt16 c;
      for (;;)
      {
	c = src->getUInt16();
	dest->putUInt16(c);
      }
      assert(false);
    }
    else if ((src_io_type & IOTYPE_UINT32) &&
	     (dest_io_type & IOTYPE_UINT32))
    {
      UInt32 c;
      for (;;)
      {
	c = src->getUInt32();
	dest->putUInt32(c);
      }
      assert(false);
    }
    else
    {
      throw IOException(__FILE__, __LINE__, IOException::IOTYPE_MISMATCH);
    }
  }
  catch (IOException& ioe)
  {
    if (ioe.errorNum() == IOException::READ_BEYOND_THE_EOF)
    {
      dest->flush();
    }
    else
    {
      throw ioe;
    }
  }
}

void
Conveyer::carry(IOType io_type) CCC_RAISES(IOException)
{
  if (!src)
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_SRC);
  }
  if (!dest)
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_DEST);
  }
  try
  {
    int src_io_type = src->getIOType();
    int dest_io_type = dest->getIOType();
    if ((io_type == IOTYPE_INT8) &&
	(src_io_type & IOTYPE_INT8) &&
	(dest_io_type & IOTYPE_INT8))
    {
      Int8 c;
      for (;;)
      {
	c = src->getInt8();
	dest->putInt8(c);
      }
      assert(false);
    }
    else if ((io_type == IOTYPE_UINT16) &&
	     (src_io_type & IOTYPE_UINT16) &&
	     (dest_io_type & IOTYPE_UINT16))
    {
      UInt16 c;
      for (;;)
      {
	c = src->getUInt16();
	dest->putUInt16(c);
      }
      assert(false);
    }
    else if ((io_type == IOTYPE_UINT32) &&
	     (src_io_type & IOTYPE_UINT32) &&
	     (dest_io_type & IOTYPE_UINT32))
    {
      UInt32 c;
      for (;;)
      {
	c = src->getUInt32();
	dest->putUInt32(c);
      }
      assert(false);
    }
    else
    {
      throw IOException(__FILE__, __LINE__, IOException::IOTYPE_MISMATCH);
    }
  }
  catch (IOException& ioe)
  {
    if (ioe.errorNum() == IOException::READ_BEYOND_THE_EOF)
    {
      dest->flush();
    }
    else
    {
      throw ioe;
    }
  }
}

void
Conveyer::carryBlock(IOType io_type, Size block_size) CCC_RAISES(IOException)
{
  if (!src)
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_SRC);
  }
  if (!dest)
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_DEST);
  }
  bool done_p = false;
  Size get_size;
  Size put_size;
  int src_io_type = src->getIOType();
  int dest_io_type = dest->getIOType();
  if ((io_type == IOTYPE_INT8) &&
      (src_io_type & IOTYPE_INT8) &&
      (dest_io_type & IOTYPE_INT8))
  {
    Int8* buf = new Int8[block_size];
    while (!done_p)
    {
      try
      {
	src->getInt8Block(block_size, buf, get_size);
      }
      catch (IOException& ioe)
      {
	block_size = get_size;
	if (ioe.errorNum() == IOException::READ_BEYOND_THE_EOF)
	{
	  done_p = true;
	}
	else
	{
	  delete[] buf;
	  throw ioe;
	}
      }
      dest->putInt8Block(block_size, buf, put_size);
    }
    delete[] buf;
  }
  else if ((io_type == IOTYPE_UINT16) &&
	   (src_io_type & IOTYPE_UINT16) &&
	   (dest_io_type & IOTYPE_UINT16))
  {
    UInt16* buf = new UInt16[block_size];
    while (!done_p)
    {
      try
      {
	src->getUInt16Block(block_size, buf, get_size);
      }
      catch (IOException& ioe)
      {
	block_size = get_size;
	if (ioe.errorNum() == IOException::READ_BEYOND_THE_EOF)
	{
	  done_p = true;
	}
	else
	{
          delete[] buf;
	  throw ioe;
	}
      }
      dest->putUInt16Block(block_size, buf, put_size);
    }
    delete[] buf;
  }
  else if ((io_type == IOTYPE_UINT32) &&
	   (src_io_type & IOTYPE_UINT32) &&
	   (dest_io_type & IOTYPE_UINT32))
  {
    UInt32* buf = new UInt32[block_size];
    while (!done_p)
    {
      try
      {
	src->getUInt32Block(block_size, buf, get_size);
      }
      catch (IOException& ioe)
      {
	block_size = get_size;
	if (ioe.errorNum() == IOException::READ_BEYOND_THE_EOF)
	{
	  done_p = true;
	}
	else
	{
          delete[] buf;
	  throw ioe;
	}
      }
      dest->putUInt32Block(block_size, buf, put_size);
    }
    delete[] buf;
  }
  else
  {
    throw IOException(__FILE__, __LINE__, IOException::IOTYPE_MISMATCH);
  }
  dest->flush();
}

CCC_NAMESPACE_END(CCC);
