﻿// $Id$

#ifndef INCLUDE_ccc_base_Conveyer_h
#define INCLUDE_ccc_base_Conveyer_h

#include <ccc/base/base.h>
#include <ccc/base/IFlow.h>
#include <ccc/base/OFlow.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * IFlowからOFlowにデータを搬送するクラスです。
 * \ja_end
 */
class Conveyer
  : public Object
{
 protected:
  /*!
   * \ja
   * 搬送元のフロー
   * \ja_end
   */
  IFlow* src;
  /*!
   * \ja
   * 搬送先のフロー
   * \ja_end
   */
  OFlow* dest;
  
 public:
  /*!
   * \ja
   * コンストラクタ
   * \param src 搬送元のフロー
   * \param dest 搬送先のフロー
   * \ja_end
   */
  Conveyer(IFlow* src = 0, OFlow* dest = 0);
  /*!
   * \ja
   * 搬送元のフローを設定します。
   * \param src 搬送元のフロー
   * \ja_end
   */
  void setSrc(IFlow* src) { Conveyer::src = src; }
  /*!
   * \ja
   * 搬送先のフローを設定します。
   * \param dest 搬送先のフロー
   * \ja_end
   */
  void setDest(OFlow* dest) { Conveyer::dest = dest; }
  /*!
   * \ja
   * データを搬送します。
   * 搬送するデータの型は、搬送元と搬送先から自動的に特定します。
   * 複数の転送データの型が見つかる場合には最初に見つかった型に
   * より転送が行なわれます。
   * \ja_end
   */
  void carry() CCC_RAISES(IOException);
  /*!
   * \ja
   * 特定の型でデータを搬送します。
   * \param io_type 搬送を行なう型
   * \retval true 搬送成功
   * \retval false 搬送失敗
   * \ja_end
   */
  void carry(IOType io_type) CCC_RAISES(IOException);
  /*!
   * \ja
   * 特定の型で特定のブロックサイズでデータを搬送します。
   * \param io_type 搬送を行なう型
   * \param block_size ブロックサイズ
   * \retval true 搬送成功
   * \retval false 搬送失敗
   * \ja_end
   */
  void carryBlock(IOType io_type, Size block_size) CCC_RAISES(IOException);
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_Conveyer_h */
