﻿// $Id$
// Copyright (C) 1992, 1993, 1994, 1999 by T.Kudou. All rights reserved.
// Copyright (C) 2000 CYPAC Co.,Inc. All rights reserved.

#include <ccc/base/Date.h>

CCC_NAMESPACE_START(CCC);

int Date::mm_table [2][13] =
{
  //    1   2   3   4   5   6   7   8   9  10  11  12
  { 0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 },
  { 0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 }
};

long
Date::getDays(int yy, int mm, int dd)
{
  long days_tbl[] = 
  {
    719162, 719527, 719892, 720258, 720623, // 1970 - 1979
    720988, 721353, 721719, 722084, 722449, 
    722814, 723180, 723545, 723910, 724275, // 1980 - 1989
    724641, 725006, 725371, 725736, 726102, 
    726467, 726832, 727197, 727563, 727928, // 1990 - 1999
    728293, 728658, 729024, 729389, 729754, 
    730119, 730485, 730850, 731215, 731580, // 2000 - 2009
    731946, 732311, 732676, 733041, 733407, 
    733772, 734137, 734502, 734868, 735233, // 2010 - 2019
    735598, 735963, 736329, 736694, 737059, 
    737424, 737790, 738155, 738520, 738885, // 2020 - 2029
    739251, 739616, 739981, 740346, 740712, 
    741077, 741442, 741807, 742173, 742538, // 2030 - 2039
    742903, 743268, 743634, 743999, 744364, 
    744729, 745095, 745460, 745825, 746190, // 2040 - 2049
    746556, 746921, 747286, 747651, 748017, 
  };
  long days = dd;
  if (leapYear(yy))
  {
    for (int i = 1; i < mm; i++)
    {
      days += mm_table[1][i];
    }
  }
  else
  {
    for (int i = 1; i < mm; i++)
    {
      days += mm_table[0][i];
    }
  }
  if ((yy >= 1970) &&(yy < 2050))
  {
    days += days_tbl[yy - 1970];
  }
  else
  {
    for (int y = 1; y < yy; y++)
    {
      days += 365 + leapYear(y);
    }
  }
  return days;
}

int
Date::getDayOfTheWeek(int yy, int mm, int dd)
{
#if 0
  return getDays(yy, mm, dd) % 7;
#else
  /* 0 = Sunday, 1 <= m <= 12, y > 1752 */
  static int t[] = {0, 0, 3, 2, 5, 0, 3, 5, 1, 4, 6, 2, 4};
  if (mm < 3)
  {
    yy--;
  }
  return (yy + yy/4 - yy/100 + yy/400 + t[mm] + dd) % 7;
#endif
}

int
Date::getWeekFrom(int yy, int mm, int ww)
{
  return getMax(((ww - 1) * 7 - getDayOfTheWeek(yy, mm, 1) + 1), 1);
}

int
Date::getWeekTo(int yy, int mm, int ww)
{
  return getMin((ww * 7) - getDayOfTheWeek(yy, mm, 1), getDaysOfTheMonth(yy, mm));
}

Date::operator long()
{
  return getDays(yy, mm, dd);
}

bool
Date::operator ==(Date& d)
{
  return (yy == d.yy) && (mm == d.mm) && (dd == d.dd);
}

Date&
Date::operator =(Date& d)
{
  yy = d.yy;
  mm = d.mm;
  dd = d.dd;
  return *this;
}

Date&
Date::operator --()
{
  if (!nilDateP())
  {
    if (dd != 1)
    {
      dd--;
    }
    else if (mm == 1)
    {
      yy--;
      mm = 12;
      dd = 31;
    }
    else
    {
      dd = getDaysOfTheMonth(yy, --mm);
    }
  }
  return *this;
}

Date&
Date::operator ++()
{
  if (!nilDateP())
  {
    if (dd < getDaysOfTheMonth(yy, mm))
    {
      dd++;
    }
    else if (mm == 12)
    {
      yy++;
      mm = 1;
      dd = 1;
    }
    else
    {
      mm++;
      dd = 1;
    }
  }
  return *this;
}

CCC_NAMESPACE_END(CCC);
