﻿// $Id$
// Copyright (C) 1992, 1993, 1994, 1999 by T.Kudou. All rights reserved.
// Copyright (C) 2000 CYPAC Co.,Inc. All rights reserved.

#ifndef INCLUDE_ccc_base_Date_h
#define INCLUDE_ccc_base_Date_h

#include <ccc/base/Magnitude.h>

CCC_NAMESPACE_START(CCC)

/*!
 * 日づけ(年月日)を扱うクラスです。
 */
class Date
  : public Object
{
  int yy;
  int mm;
  int dd;

 public:
  Date() { yy = mm = dd = 0; }
  Date(Date& d);
  // Date (long d);
  Date(int yy, int mm, int dd)
  {
    Date::yy = yy;
    Date::mm = mm;
    Date::dd = dd;
  }
  // void SetToday();
  bool nilDateP() const { return dd == 0; }
  int getYear() const { return yy; }
  int getMonth() const { return mm; }
  int getDay() const { return dd; }

  operator long();
  bool operator == (Date& d);
  Date& operator = (Date& d);
  // Date& operator -= (long d);
  // Date& operator += (long d);
  // Date& operator -= (Date& d);
  // Date& operator += (Date& d);
  Date& operator -- ();
  Date& operator ++ ();
  // friend Date operator - (Date& d1, Date& d2);
  // friend Date operator + (Date& d1, Date& d2);
  // friend Date operator - (Date& d1, long d2);
  // friend Date operator + (Date& d1, long d2);

 private:
  static int mm_table[2][13];

 public:
  // Leap year check.
  // yy: year
  static bool leapYearP (int yy)
  {
    return ((yy % 4 == 0) && (yy % 100 != 0)) || (yy % 400 == 0);
  }

  // Return 1 in case of leap year, else return 0.
  // yy: year
  static int leapYear (int yy)
  {
    return leapYearP (yy) ? 1 : 0;
  }

  // Get total dates from 1/1/1.
  static long getDays(int yy, int mm, int dd);

  // Get days of the month.
  // yy: year, mm: month
  static int getDaysOfTheMonth(int yy, int mm)
  {
    return leapYearP (yy) ? mm_table[1][mm] : mm_table[0][mm];
  }

  // Get day of the week.
  // yy: year, mm: month dd: day
  // return 0: SUN, 1: MON, 2: TUE, 3: WED, 4: THR, 5: FRI, 6:SAT
  static int getDayOfTheWeek (int yy, int mm, int dd);

  // Get start day of the week.
  // yy: year, mm: month ww: week
  static int getWeekFrom (int yy, int mm, int ww);

  // Get end day of the week.
  // yy: year, mm: month ww: week
  static int getWeekTo (int yy, int mm, int ww);
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_Date_h */
