﻿// $Id$

#ifndef INCLUDE_ccc_base_Dict_h
#define INCLUDE_ccc_base_Dict_h

#include <ccc/base/Set.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * 辞書クラス
 * \ja_end
 */
template <class Element, class Key>
class Dict
  : public Set<Element>
{
 protected:
  /*!
   * \ja
   * 要素からキーを取り出します。
   * \param element キーを取り出す要素
   * \return キーへのポインタ
   * \ja_end
   */ 
  virtual const Key* getKey(const Element* element) const = 0;
  /*!
   * \ja
   * キーを比較します。
   * \param key1 キー1
   * \param key2 キー2
   * \retval 0 同一
   * \retval マイナス値 キー1の方が小さい
   * \retval プラス値 キー1の方が大きい
   * \ja_end
   */
  virtual int compare(const Key* key1, const Key* key2) const = 0;
  /*!
   * \ja
   * クラス内部利用用、要素同士の比較用メソッドです。
   * \param element1 要素1
   * \param element2 要素2
   * \retval 比較結果、数字の意味はcompareメソッドと同じもの
   * \ja_end
   */
  int compareX(const Element* element1, const Element* element2) const
  {
    return compare(getKey(element1), getKey(element2));
  }
  /*!
   * \ja
   * クラス内部利用用、要素とキー比較用のメソッドです。
   * \param element 要素
   * \param key キー
   * \retval 比較結果、数字の意味はcompareメソッドと同じもの
   * \ja_end
   */
  int compareWithElement(const Element* element, const Key* key) const
  {
    return compare(getKey(element), key);
  }

 public:
  /*!
   * \ja
   * コンストラクタ
   * \ja_end
   * \en
   * constructor
   * \en_end
   */
  Dict() { }
  /*!
   * \ja
   * デストラクタ
   * \ja_end
   * \en
   * destructor
   * \en_end
   */
  virtual ~Dict() { }

  // Collection interface
  // see <ccc/base/Collection.h>
  virtual bool emptyP() const = 0;
  virtual Size number() const = 0;
  virtual bool add(Element* element) = 0;
  virtual bool remove(Element* element) = 0;
  virtual void clear() = 0;
  virtual bool elementP(Element* element) const = 0;
  virtual Iterator<Element>* createIterator() const = 0;

  // Dict interface
  /*!
   * \ja
   * 検索を行ないます。
   * \param key 検索を行なうキー
   * \return 見つかった要素
   * \ja_end
   */
  virtual Element* search(const Key* key) const = 0;
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_Dict_h */
