﻿// $Id$

#ifndef INCLUDE_ccc_base_Exception_h
#define INCLUDE_ccc_base_Exception_h

#include <ccc/base/base.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * 各例外用クラスの基本クラスとなるクラスです。
 * \ja_end
 */
class Exception
  : public Object
{
  /*!
   * \ja
   * 例外の発生したファイル名
   * \ja_end
   */
  const char* file_name;
  /*!
   * \ja
   * 例外の発生した行番号
   * \ja_end
   */
  int line_num;
 public:
  /*!
   * \ja
   * コンストラクタ
   * \param file_name ソースコードのファイル名、__FILE__が引数として渡されることを想定しています。
   * \param line_num 行番号、__LINE__が引数として渡されることを想定しています。
   * \ja_end
   */
  Exception(const char* file_name, int line_num)
  {
    Exception::file_name = file_name;
    Exception::line_num = line_num;
  }
  /*!
   * \ja
   * 例外の発生した箇所のファイル名を返します。
   * \return ファイル名
   * \ja_end
   */
  const char* getFileName() { return file_name; }
  /*!
   * \ja
   * 例外の発生した箇所の行番号を返します。
   * \ja_end
   */
  int getLineNumber() { return line_num; }
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_Exception_h */
