﻿// $Id$

#include <assert.h>
#include <ccc/base/FixedMemIFlow.h>

CCC_NAMESPACE_START(CCC)

FixedMemIFlow::FixedMemIFlow()
  : IFlow(IOTYPE_ANY)
{
  from = 0;
  to = 0;
  p = 0;
  setOpened(false);
}

FixedMemIFlow::FixedMemIFlow(const void* mem, Size size)
  : IFlow(IOTYPE_ANY)
{
  set(mem, size);
}

FixedMemIFlow::~FixedMemIFlow()
{
}

FixedMemIFlow::FixedMemIFlow(Allocator* mem)
  : IFlow(IOTYPE_ANY)
{
  set(mem->getMem(), mem->getUsedSize());
}

void
FixedMemIFlow::set(const void* mem, Size size)
{
  if (mem == 0)
  {
    from = 0;
    to = 0;
    p = 0;
    setOpened(false);
  }
  else if (size == 0)
  {
    from = (const UInt8*)mem;
    to = (const UInt8*)mem;
    p = (const UInt8*)mem + 1;
    setOpened(true);
  }
  else
  {
    from = (const UInt8*)mem;
    to = (const UInt8*)mem + size - 1;
    p = (const UInt8*)mem;
    setOpened(true);
  }
}

Int8
FixedMemIFlow::getInt8() CCC_RAISES(IOException)
{
  if (!openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::NOT_OPENED);
  }
  assert(p);
  if (p > to)
  {
    throw IOException(__FILE__, __LINE__, IOException::READ_BEYOND_THE_EOF);
  }
  Int8* x = (Int8*)p;
  p++;
  return *x;
}

UInt16
FixedMemIFlow::getUInt16() CCC_RAISES(IOException)
{
  if (!openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::NOT_OPENED);
  }
  assert(p);
  if (p > to - (sizeof(UInt16) - 1))
  {
    throw IOException(__FILE__, __LINE__, IOException::READ_BEYOND_THE_EOF);
  }
  const UInt16* x = (const UInt16*)p;
  p += sizeof(UInt16);
  return *x;
}

UInt32
FixedMemIFlow::getUInt32() CCC_RAISES(IOException)
{
  if (!openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::NOT_OPENED);
  }
  assert(p);
  if (p > to - (sizeof(UInt32) - 1))
  {
    throw IOException(__FILE__, __LINE__, IOException::READ_BEYOND_THE_EOF);
  }
  const UInt32* x = (const UInt32*)p;
  p += sizeof(UInt32);
  return *x;
}

bool
FixedMemIFlow::rewind()
{
  if (openedP())
  {
    p = from;
    assert(p);
  }
  else
  {
    return false;
  }
  return IFlow::rewind();
}

bool
FixedMemIFlow::close()
{
  from = 0;
  to = 0;
  p = 0;
  setOpened(false);
  return true;
}

bool
FixedMemIFlow::topP()
{
  if (!openedP())
  {
    return false;
  }
  assert(p);
  return p == from;
}

CCC_NAMESPACE_END(CCC)
