﻿// $Id$

#ifndef INCLUDE_ccc_base_FixedMemIFlow_h
#define INCLUDE_ccc_base_FixedMemIFlow_h

#include <ccc/base/IFlow.h>
#include <ccc/base/Allocator.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * メモリ入力フロー
 * Int8, UInt16, UInt32の型の入力をサポートします。
 * \ja_end
 */
class FixedMemIFlow
  : public IFlow
{
  const UInt8* from;
  const UInt8* to;
  const UInt8* p;
  
 public:
  /*!
   * \ja
   * コンストラクタ<br>
   * フローはオープンされません。
   * \ja_end
   */
  FixedMemIFlow();
  /*!
   * \ja
   * コンストラクタ<br>
   * memとsizeが0でなければフローをオープンします。
   * \param mem メモリの先頭アドレス
   * \param size バイトサイズ
   * \ja_end
   */
  FixedMemIFlow(const void* mem, Size size);
  /*!
   * \ja
   * コンストラクタ<br>
   * \param mem アロケータ
   * \ja_end
   */
  FixedMemIFlow(Allocator* mem);
  /*!
   * \ja
   * デストラクタ
   * \ja_end
   */
  virtual ~FixedMemIFlow();
  /*!
   * 入力元のメモリとサイズをセットしフローをオープンします。
   * memとsizeが0でなければフローをオープンします。
   * \param mem メモリの先頭アドレス
   * \param size バイトサイズ
   */
  void set(const void* mem, Size size);
  /*!
   * \ja
   * IFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual Int8 getInt8() CCC_RAISES(IOException);
  /*!
   * \ja
   * IFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  /*!
   * \ja
   * IFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
  /*!
   * \ja
   * Flowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual bool rewind();
  /*!
   * \ja
   * フローをクローズします。
   * クローズ以降のデータ取得を行うとNOT_OPENEDの例外が発生します。
   * フローがオープンされていなくてもクローズは成功します。
   * \retval true クローズ成功
   * \ja_end
   */
  virtual bool close();
  /*!
   * \ja
   * Flowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual bool topP();
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_FixedMemIFlow_h */
