﻿// $Id$

#include <assert.h>
#include <ccc/base/FixedMemOFlow.h>

CCC_NAMESPACE_START(CCC)

FixedMemOFlow::FixedMemOFlow()
  : OFlow(IOTYPE_ANY)
{
  from = 0;
  to = 0;
  p = 0;
  setOpened(false);
}

FixedMemOFlow::FixedMemOFlow(void* mem, Size size)
  : OFlow(IOTYPE_ANY)
{
  set(mem, size);
}

FixedMemOFlow::~FixedMemOFlow()
{
}

void
FixedMemOFlow::set(void* mem, Size size)
{
  if ((mem == 0) || (size == 0))
  {
    from = 0;
    to = 0;
    p = 0;
    setOpened(false);
  }
  else
  {
    from = (UInt8*)mem;
    to = (UInt8*)mem + size - 1;
    p = (UInt8*)mem;
    setOpened(true);
  }
}

void
FixedMemOFlow::putInt8(Int8 c) CCC_RAISES(IOException)
{
  if (!openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::NOT_OPENED);
  }
  assert(p);
  if (p > to)
  {
    throw IOException(__FILE__, __LINE__, IOException::WRITE_BEYOND_THE_EOF);
  }
  Int8* x = (Int8*)p;
  p++;
  *x = c;
}

void
FixedMemOFlow::putUInt16(UInt16 c) CCC_RAISES(IOException)
{
  if (!openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::NOT_OPENED);
  }
  assert(p);
  if (p > to - (sizeof(UInt16) - 1))
  {
    throw IOException(__FILE__, __LINE__, IOException::WRITE_BEYOND_THE_EOF);
  }
  UInt16* x = (UInt16*)p;
  p += sizeof(UInt16);
  *x = c;
}

void
FixedMemOFlow::putUInt32(UInt32 c) CCC_RAISES(IOException)
{
  if (!openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::NOT_OPENED);
  }
  assert(p);
  if (p > to - (sizeof(UInt32) - 1))
  {
    throw IOException(__FILE__, __LINE__, IOException::WRITE_BEYOND_THE_EOF);
  }
  UInt32* x = (UInt32*)p;
  p += sizeof(UInt32);
  *x = c;
}

bool
FixedMemOFlow::rewind()
{
  if (openedP())
  {
    p = from;
    assert(p);
  }
  else
  {
    return false;
  }
  return OFlow::rewind();
}

bool
FixedMemOFlow::close()
{
  from = 0;
  to = 0;
  p = 0;
  setOpened(false);
  return true;
}

bool
FixedMemOFlow::topP()
{
  if (!openedP())
  {
    return false;
  }
  return p == from;
}

CCC_NAMESPACE_END(CCC)
