﻿// $Id$

#ifndef INCLUDE_ccc_base_FixedMemOFlow_h
#define INCLUDE_ccc_base_FixedMemOFlow_h

#include <ccc/base/OFlow.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * メモリ出力フロー
 * 特定のメモリ領域にデータを出力します。
 * \ja_end
 */
class FixedMemOFlow
  : public OFlow
{
  UInt8* from;
  UInt8* to;
  UInt8* p;

 public:
  /*!
   * \ja
   * コンストラクタ<br>
   * フローはオープンされません。
   * \ja_end
   */
  FixedMemOFlow();
  /*!
   * \ja
   * コンストラクタ<br>
   * memとsizeが0でなければフローをオープンします。
   * \param mem メモリの先頭アドレス
   * \param size バイトサイズ
   * \ja_end
   */
  FixedMemOFlow(void* mem, Size size);
  /*!
   * \ja
   * デストラクタ
   * \ja_end
   */
  virtual ~FixedMemOFlow();
  /*!
   * 出力先のメモリとサイズをセットします。
   * memとsizeが0でなければフローをオープンします。
   * \param mem メモリの先頭アドレス
   * \param size バイトサイズ
   */
  void set(void* mem, Size size);
  /*!
   * \ja
   * OFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual void putInt8(Int8 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * OFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual void putUInt16(UInt16 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * OFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual void putUInt32(UInt32 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * Flowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual bool rewind();
  /*!
   * \ja
   * フローをクローズします。
   * クローズ以降のデータ取得を行うとNOT_OPENEDの例外が発生します。
   * フローがオープンされていなくてもクローズは成功します。
   * \retval true クローズ成功
   * \ja_end
   */
  virtual bool close();
  /*!
   * \ja
   * Flowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual bool topP();
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_FixedMemOFlow_h */
