﻿// $Id$

#include <ccc/base/Flow.h>

CCC_NAMESPACE_START(CCC);

// ------------------------------------------------------------------------
// class Flow
Flow::Flow(IOType io_type)
{
  opened_p = true;
  Flow::io_type = io_type;
  top_of_flow_p = true;
}

Flow::~Flow()
{
}

void
Flow::setOpened(bool p)
{
  opened_p = p;
  top_of_flow_p = p;
}

bool
Flow::close()
{
  if (opened_p)
  {
    opened_p = false;
    return true;
  }
  return false;
}

bool
Flow::openedP()
{
  return opened_p;
}

IOType
Flow::getIOType()
{
  return io_type;
}

bool
Flow::inspectTheTypedIOSupport(IOType t)
{
  if (getIOType() & t)
  {
    return true;
  }
  return false;
}

bool
Flow::rewind()
{
  if (opened_p)
  {
    top_of_flow_p = true;
    return true;
  }
  return false;
}

void
Flow::setIOType(IOType io_type)
{
  Flow::io_type = io_type;
}

bool
Flow::topP()
{
  return top_of_flow_p;
}

void
Flow::setTopP(bool p)
{
  top_of_flow_p = p;
}

bool
Flow::validCombinationP()
{
  return openedP();
}

CCC_NAMESPACE_END(CCC);
