﻿// $Id$

#ifndef INCLUDE_ccc_base_Flow_h
#define INCLUDE_ccc_base_Flow_h

#include <ccc/base/base.h>
#include <ccc/base/IOType.h>
#include <ccc/base/IOException.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * IFlowおよびOFlowの基本クラスとなるフローを表現する仮想クラス
 * \ja_end
 */
class Flow
  : public Object
{
  /*!
   * \ja
   * フローがオープンされているかどうかのフラグ。
   * true だったらオープンされていることを示します。
   * オープンとクローズの処理が不要なフローの場合falseがセットされます。
   * \ja_end
   */
  bool opened_p;
  /*!
   * \ja
   * サポートされている I/O が可能な型のビットマスク。
   * IOTypeで示されるビットパターンをオアした値がセットされます。
   * \ja_end
   */
  IOType io_type;
  /*!
   * \ja
   * フローの先頭かどうかを表現するフラグ
   * \ja_end
   */
  bool top_of_flow_p;

 protected:
  /*!
   * \ja
   * フローのオープンフラグをセットします。
   * \param p セットする値
   * \ja_end
   */
  void setOpened(bool p);
  /*!
   * \ja
   * I/O をサポートしている型をセットします。
   * IOTypeで示されるビットパターンをオアした値を引数として渡します。
   * \param io_type セットする型
   * \ja_end
   */
  void setIOType(IOType io_type);
  /*!
   * フローの先頭かどうかを表現するフラグをセットします。
   * \param p セットする値
   */
  void setTopP(bool p);

 public:
  /*!
   * \ja
   * コンストラクタ
   * \param io_type I/Oをサポートしている型
   * \ja_end
   */
  Flow(IOType io_type = IOTYPE_NULL);
  /*!
   * \ja
   * デストラクタ
   * \ja_end
   */
  virtual ~Flow();
  /*!
   * \ja
   * \brief フローをクローズします。
   *
   * オープンとクローズの処理が不要なフローの場合、falseを返します。
   * \retval true  クローズ成功
   * \retval false クローズ失敗。既にクローズされている状態で
   *		   このメソッドを呼び出した場合も、falseになります。
   * \ja_end
   */
  virtual bool close();
  /*!
   * \ja
   * \brief フローがオープンされているかどうかを返します。
   *
   * オープンとクローズの処理が不要なフローの場合、falseを返します。
   * \retval true  オープンされている
   * \retval false オープンされていない
   * \ja_end
   */
  virtual bool openedP();
  /*!
   * \ja
   * I/O をサポートしている型をビットパターンにして返します。
   * \return 出力のサポートされている型のビットパターン
   * \ja_end
   */
  virtual IOType getIOType();
  /*!
   * \ja
   * 指定した型の入出力が可能かを調べます。
   * \param t 調べる型
   * \retval true 入出力が可能
   * \retval false 入出力が不能
   * \ja_end
   */
  virtual bool inspectTheTypedIOSupport(IOType t);
  /*!
   * \ja
   * フローの読み書き位置を先頭に巻き戻し、フローのステータスを初期状態に戻します。
   * \retval true 巻き戻し成功
   * \retval false 巻き戻し失敗
   * \ja_end
   */
  virtual bool rewind();
  /*!
   * \ja
   * フローの読み書き位置が先頭かどうかを調べます。
   * \retval true 先頭
   * \retval false 先頭以外、フローがオープンされていない場合もfalseになります。
   * \ja_end
   */
  virtual bool topP();
  /*!
   * \ja
   * フィルタ元とフィルタの入力、あるいはフィルタ先とフィルタの出力が
   * 前提とする型が合致するかをフィルタのチェーンをたどり再帰的に調べます。
   * FlowのvalidCombinationP()メソッドはフローがオープンされていれば
   * trueを返します。
   * \retval true 合致する
   * \retval false 合致しない
   * \ja_end
   */
  virtual bool validCombinationP();
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_Flow_h */
