﻿// $Id$

#include <ccc/base/FmtArg.h>

CCC_NAMESPACE_START(CCC)

template <typename T>
FmtArg<T>::FmtArg(void* x)
{
  type = VOID_PTR;
  vp_val = x;
}

template <typename T>
FmtArg<T>::FmtArg(signed char c)
{
  type = SIGNED_CHAR;
  sc_val = c;
}

template <typename T>
FmtArg<T>::FmtArg(unsigned char c)
{
  type = UNSIGNED_CHAR;
  uc_val = c;
}

template <typename T>
FmtArg<T>::FmtArg(signed short int c)
{
  type = SIGNED_SHORT_INT;
  ssi_val = c;
}

template <typename T>
FmtArg<T>::FmtArg(unsigned short int c)
{
  type = UNSIGNED_SHORT_INT;
  usi_val = c;
}

template <typename T>
FmtArg<T>::FmtArg(signed int c)
{
  type = SIGNED_INT;
  si_val = c;
}

template <typename T>
FmtArg<T>::FmtArg(unsigned int c)
{
  type = UNSIGNED_INT;
  ui_val = c;
}

template <typename T>
FmtArg<T>::FmtArg(signed long int c)
{
  type = SIGNED_LONG_INT;
  sli_val = c;
}

template <typename T>
FmtArg<T>::FmtArg(unsigned long int c)
{
  type = UNSIGNED_LONG_INT;
  uli_val = c;
}

template <typename T>
FmtArg<T>::FmtArg(const T* s)
{
  type = T_PTR;
  tp_val = s;
}

template <typename T>
FmtArg<T>::FmtArg(const TString<T>* s)
{
  type = STRING_T_PTR;
  stp_val = s;
}

template <typename T>
FmtArg<T>::FmtArg(TString<T>& s)
{
  type = STRING_T_PTR;
  stp_val = &s;
}

template <typename T>
FmtArg<T>::FmtArg(double d)
{
  type = DOUBLE;
  d_val = d;
}

template <typename T>
FmtArg<T>::FmtArg(float f)
{
  type = FLOAT;
  f_val = f;
}

template <typename T>
FmtArg<T>::FmtArg(int* p)
{
  type = INT_PTR;
  ip_val = p;
}

template <typename T>
bool
FmtArg<T>::set(void* x)
{
  bool p = (type == VOID_PTR);
  type = VOID_PTR;
  vp_val = x;
  return p;
}

template <typename T>
bool
FmtArg<T>::set(signed char c)
{
  bool p = (type == SIGNED_CHAR);
  type = SIGNED_CHAR;
  sc_val = c;
  return p;
}

template <typename T>
bool
FmtArg<T>::set(unsigned char c)
{
  bool p = (type == UNSIGNED_CHAR);
  type = UNSIGNED_CHAR;
  uc_val = c;
  return p;
}

template <typename T>
bool
FmtArg<T>::set(signed short int c)
{
  bool p = (type == SIGNED_SHORT_INT);
  type = SIGNED_SHORT_INT;
  ssi_val = c;
  return p;
}

template <typename T>
bool
FmtArg<T>::set(unsigned short int c)
{
  bool p = (type == UNSIGNED_SHORT_INT);
  type = UNSIGNED_SHORT_INT;
  usi_val = c;
  return p;
}

template <typename T>
bool
FmtArg<T>::set(signed int c)
{
  bool p = (type == SIGNED_INT);
  type = SIGNED_INT;
  si_val = c;
  return p;
}

template <typename T>
bool
FmtArg<T>::set(unsigned int c)
{
  bool p = (type == UNSIGNED_INT);
  type = UNSIGNED_INT;
  ui_val = c;
  return p;
}

template <typename T>
bool
FmtArg<T>::set(signed long int c)
{
  bool p = (type == SIGNED_LONG_INT);
  type = SIGNED_LONG_INT;
  sli_val = c;
  return p;
}

template <typename T>
bool
FmtArg<T>::set(unsigned long int c)
{
  bool p = (type == UNSIGNED_LONG_INT);
  type = UNSIGNED_LONG_INT;
  uli_val = c;
  return p;
}

template <typename T>
bool
FmtArg<T>::set(const T* s)
{
  bool p = (type == T_PTR);
  type = T_PTR;
  tp_val = s;
  return p;
}

template <typename T>
bool
FmtArg<T>::set(const TString<T>* s)
{
  bool p = (type == STRING_T_PTR);
  type = STRING_T_PTR;
  stp_val = s;
  return p;
}

template <typename T>
bool
FmtArg<T>::set(TString<T>& s)
{
  bool p = (type == STRING_T_PTR);
  type = STRING_T_PTR;
  stp_val = &s;
  return p;
}

template <typename T>
bool
FmtArg<T>::set(double d)
{
  bool p = (type == DOUBLE);
  type = DOUBLE;
  d_val = d;
  return p;
}

template <typename T>
bool
FmtArg<T>::set(float f)
{
  bool p = (type == FLOAT);
  type = FLOAT;
  f_val = f;
  return p;
}

template <typename T>
bool
FmtArg<T>::set(int* ip)
{
  bool p = (type == INT_PTR);
  type = INT_PTR;
  ip_val = ip;
  return p;
}

template class FmtArg<Int8>;
template class FmtArg<UInt16>;
template class FmtArg<UInt32>;

CCC_NAMESPACE_END(CCC)
