﻿// $Id$

#ifndef INCLUDE_ccc_base_FmtArg_h
#define INCLUDE_ccc_base_FmtArg_h

#include <ccc/base/base.h>
#include <ccc/base/TString.h>

CCC_NAMESPACE_START(CCC)

// forward ref.
template <typename T> class Formatter;

/*!
 * フォーマッタの引数に用いるクラスです。
 */
template <typename T>
class FmtArg
{
  friend class Formatter<T>;
 public:
  enum Type
  {
    VOID_PTR,
    SIGNED_CHAR,
    UNSIGNED_CHAR,
    SIGNED_SHORT_INT,
    UNSIGNED_SHORT_INT,
    SIGNED_INT,
    UNSIGNED_INT,
    SIGNED_LONG_INT,
    UNSIGNED_LONG_INT,
    T_PTR,
    STRING_T_PTR,
    DOUBLE,
    FLOAT,
    INT_PTR,
    /*!
     * その他、FmtArgの継承用
     */
    OTHER,
  };

 private:
  Type type;
  union
  {
    void* vp_val;
    signed char sc_val;
    unsigned char uc_val;
    signed short int ssi_val;
    unsigned short int usi_val;
    signed int si_val;
    unsigned int ui_val;
    signed long int sli_val;
    unsigned long int uli_val;
    const T* tp_val;
    const TString<T>* stp_val;
    double d_val;
    float f_val;
    int* ip_val;
  };
 protected:
  void setType(Type t) { type = t; }

 public:
  FmtArg(void* x);
  FmtArg(signed char c);
  FmtArg(unsigned char c);
  FmtArg(signed short int c);
  FmtArg(unsigned short int c);
  FmtArg(signed int c);
  FmtArg(unsigned int c);
  FmtArg(signed long int c);
  FmtArg(unsigned long int c);
  FmtArg(const T* s);
  FmtArg(const TString<T>* s);
  FmtArg(TString<T>& s);
  FmtArg(double d);
  FmtArg(float f);
  FmtArg(int* p);
  Type getType() { return type; }
  /*!
   * 値をセットします。
   * \retval true 型は前と同じ
   * \retval false 型が変更になった
   */
  bool set(void* x);
  /*!
   * 値をセットします。
   * \retval true 型は前と同じ
   * \retval false 型が変更になった
   */
  bool set(signed char c);
  /*!
   * 値をセットします。
   * \retval true 型は前と同じ
   * \retval false 型が変更になった
   */
  bool set(unsigned char c);
  /*!
   * 値をセットします。
   * \retval true 型は前と同じ
   * \retval false 型が変更になった
   */
  bool set(signed short int c);
  /*!
   * 値をセットします。
   * \retval true 型は前と同じ
   * \retval false 型が変更になった
   */
  bool set(unsigned short int c);
  /*!
   * 値をセットします。
   * \retval true 型は前と同じ
   * \retval false 型が変更になった
   */
  bool set(signed int c);
  /*!
   * 値をセットします。
   * \retval true 型は前と同じ
   * \retval false 型が変更になった
   */
  bool set(unsigned int c);
  /*!
   * 値をセットします。
   * \retval true 型は前と同じ
   * \retval false 型が変更になった
   */
  bool set(signed long int c);
  /*!
   * 値をセットします。
   * \retval true 型は前と同じ
   * \retval false 型が変更になった
   */
  bool set(unsigned long int c);
  /*!
   * 値をセットします。
   * \retval true 型は前と同じ
   * \retval false 型が変更になった
   */
  bool set(const T* s);
  /*!
   * 値をセットします。
   * \retval true 型は前と同じ
   * \retval false 型が変更になった
   */
  bool set(const TString<T>* s);
  /*!
   * 値をセットします。
   * \retval true 型は前と同じ
   * \retval false 型が変更になった
   */
  bool set(TString<T>& s);
  /*!
   * 値をセットします。
   * \retval true 型は前と同じ
   * \retval false 型が変更になった
   */
  bool set(double d);
  /*!
   * 値をセットします。
   * \retval true 型は前と同じ
   * \retval false 型が変更になった
   */
  bool set(float f);
  /*!
   * 値をセットします。
   * \retval true 型は前と同じ
   * \retval false 型が変更になった
   */
  bool set(int* p);
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_FmtArg_h */
