﻿// $Id$

#ifndef INCLUDE_ccc_base_FmtException_h
#define INCLUDE_ccc_base_FmtException_h

#include <ccc/base/Exception.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * フォーマッタ用の例外を表現するクラスです。
 * \ja_end
 */
class FmtException
  : public Exception
{
 public:
  enum ErrorNum
  {
    /*!
     * \ja
     * 該当の引数が存在しません。
     * \ja_end
     */
    NO_APPLICABLE_ARG,
    /*!
     * \ja
     * 引数の型が違います。
     * \ja_end
     */
    DIFFERENT_TYPE_ARG,
    /*!
     * \ja
     * 出力先のメモリが不足しています。
     * \ja_end
     */
    INSUFFICIENT_DISTINATION_MEMORY,
    /*!
     * \ja
     * サポートされていないメソッド呼び出しです。
     * \ja_end
     */
    NOT_SUPPORTED,
    /*!
     * \ja
     * 不正な変換指定子がフォーマット文字列で指定されました。
     * \ja_end
     */
    INVALID_FORMAT_SPECIFIER,
  };
 private:
  /*!
   * \ja
   * エラー番号
   * \ja_end
   */
  ErrorNum num;
  
 public:
  /*!
   * \ja
   * コンストラクタ
   * \ja_end
   */
  FmtException(const char* file_name, int line_num, ErrorNum num)
    : Exception(file_name, line_num)
  {
    FmtException::num = num;
  }
  /*!
   * \ja
   * エラー番号を取り出します。
   * \retval エラー番号
   * \ja_end
   */
  ErrorNum errorNum() { return num; }
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_FmtException_h */
