﻿// $Id$

#include <ccc/base/IFilter.h>

CCC_NAMESPACE_START(CCC)

IFilter::IFilter(IOType my_io_type, IOType src_io_type, IFlow* src_)
  : IFlow(my_io_type), src(src_)
{
  IFilter::src_io_type = src_io_type;
  setOpened(!!src);
}

IFilter::~IFilter()
{
}

void
IFilter::setSrc(IFlow* src_)
{
  src = src_;
  setOpened(!!src);
  setTopP(true);
}

IOType
IFilter::getSrcCombinationIOType()
{
  if (openedP())
  {
    return (IOType)(src->getIOType() & src_io_type);
  }
  return IOTYPE_NULL;
}

bool
IFilter::validCombinationP()
{
  if (getSrcCombinationIOType() == IOTYPE_NULL)
  {
    return false;
  }
  if (!src)
  {
    return false;
  }
  return src->validCombinationP();
}

bool
IFilter::close()
{
  if (!openedP())
  {
    return false;
  }
  src = 0;
  return true;
}

bool
IFilter::openedP()
{
  return !!src;
}

bool
IFilter::rewind()
{
  if (!openedP())
  {
    return false;
  }
  Flow::rewind();
  return src->rewind();
}

bool
IFilter::topP()
{
  return Flow::topP();
}

Int8
IFilter::getInt8() CCC_RAISES(IOException)
{
  if (!openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_SRC);
  }
  Int8 ret = src->getInt8();
  setTopP(false);
  return ret;
}

UInt16
IFilter::getUInt16() CCC_RAISES(IOException)
{
  if (!openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_SRC);
  }
  UInt16 ret = src->getUInt16();
  setTopP(false);
  return ret;
}

UInt32
IFilter::getUInt32() CCC_RAISES(IOException)
{
  if (!openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_SRC);
  }
  UInt32 ret = src->getUInt32();
  setTopP(false);
  return ret;
}

void
IFilter::getInt8Block(Size block_size, Int8* ptr, Size& get_size) CCC_RAISES(IOException)
{
  if (!openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_SRC);
  }
  src->getInt8Block(block_size, ptr, get_size);
  setTopP(false);
}

void
IFilter::getUInt16Block(Size block_size, UInt16* ptr, Size& get_size) CCC_RAISES(IOException)
{
  if (!openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_SRC);
  }
  src->getUInt16Block(block_size, ptr, get_size);
  setTopP(false);
}

void
IFilter::getUInt32Block(Size block_size, UInt32* ptr, Size& get_size) CCC_RAISES(IOException)
{
  if (!openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_SRC);
  }
  src->getUInt32Block(block_size, ptr, get_size);
  setTopP(false);
}

CCC_NAMESPACE_END(CCC)
