﻿// $Id$

#include <ccc/base/IFlow.h>

CCC_NAMESPACE_START(CCC)

IFlow::IFlow(IOType io_type)
  : Flow(io_type)
{
}

IFlow::~IFlow()
{
}

Int8
IFlow::getInt8() CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
  return 0;
}

UInt16
IFlow::getUInt16() CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
  return 0;
}

UInt32
IFlow::getUInt32() CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
  return 0;
}

void
IFlow::getInt8Block(Size block_size, Int8* ptr, Size& get_size) CCC_RAISES(IOException)
{
  try
  {
    Size n;
    get_size = 0;
    for (n = 0; n < block_size; n++)
    {
      *ptr++ = getInt8();
      get_size++;
    }
  }
  catch (IOException ioe)
  {
    if (ioe.errorNum() != IOException::READ_BEYOND_THE_EOF)
    {
      throw ioe;
    }
  }
}

void
IFlow::getUInt16Block(Size block_size, UInt16* ptr, Size& get_size) CCC_RAISES(IOException)
{
  try
  {
    Size n;
    get_size = 0;
    for (n = 0; n < block_size; n++)
    {
      *ptr++ = getUInt16();
      get_size++;
    }
  }
  catch (IOException ioe)
  {
    if (ioe.errorNum() != IOException::READ_BEYOND_THE_EOF)
    {
      throw ioe;
    }
  }
}

void
IFlow::getUInt32Block(Size block_size, UInt32* ptr, Size& get_size) CCC_RAISES(IOException)
{
  try
  {
    Size n;
    get_size = 0;
    for (n = 0; n < block_size; n++)
    {
      *ptr++ = getUInt32();
      get_size++;
    }
  }
  catch (IOException ioe)
  {
    if (ioe.errorNum() != IOException::READ_BEYOND_THE_EOF)
    {
      throw ioe;
    }
  }
}

bool
IFlow::getLine(BString* to, bool append_p) CCC_RAISES(IOException)
{
  if (!append_p)
  {
    to->clear();
  }
  bool retval = false;
  try
  {
    Int8 c;
    while ((c = getInt8()))
    {
      to->add(c);
      if (c == 0x0a)
      {
	break;
      }
    }
  }
  catch (IOException ioe)
  {
    if (ioe.errorNum() == IOException::R_EOF)
    {
      retval = true;
    }
    else
    {
      throw ioe;
    }
  }
  return retval;
}

bool
IFlow::getLine(DString* to, bool append_p) CCC_RAISES(IOException)
{
  if (!append_p)
  {
    to->clear();
  }

  bool retval = false;
  try
  {
    UInt16 c;
    while ((c = getUInt16()))
    {
      to->add(c);
      if (c == 0x0a)
      {
	break;
      }
    }
  }
  catch (IOException ioe)
  {
    if (ioe.errorNum() == IOException::R_EOF)
    {
      retval = true;
    }
    else
    {
      throw ioe;
    }
  }
  return retval;
}

bool
IFlow::getLine(WString* to, bool append_p) CCC_RAISES(IOException)
{
  if (!append_p)
  {
    to->clear();
  }
  bool retval = false;
  try
  {
    UInt32 c;
    while ((c = getUInt32()))
    {
      to->add(c);
      if (c == 0x0a)
      {
	break;
      }
    }
  }
  catch (IOException ioe)
  {
    if (ioe.errorNum() == IOException::R_EOF)
    {
      retval = true;
    }
    else
    {
      throw ioe;
    }
  }
  return retval;
}

CCC_NAMESPACE_END(CCC)
