﻿// $Id$

#ifndef INCLUDE_ccc_base_IFlow_h
#define INCLUDE_ccc_base_IFlow_h

#include <ccc/base/Flow.h>
#include <ccc/base/TString.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * 入力用フローの基本クラスです。
 * \ja_end
 */
class IFlow
  : public Flow
{
 public:
  /*!
   * \ja
   * コンストラクタ
   * \param io_type サポートする型
   * \ja_end
   */
  IFlow(IOType io_type = IOTYPE_NULL);
  /*!
   * \ja
   * デストラクタ
   * \ja_end
   */
  virtual ~IFlow() = 0;
  /*!
   * \ja
   * Int8のデータを取り出します。
   * \return 取り出した値
   * \exception IOException
   * \ja_end
   */
  virtual Int8 getInt8() CCC_RAISES(IOException);
  /*!
   * \ja
   * UInt16のデータを取り出します。
   * \return 取り出した値
   * \exception IOException
   * \ja_end
   */
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  /*!
   * \ja
   * UInt32 のデータを取り出します。
   * \return 取り出した値
   * \exception IOException
   * \ja_end
   */
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
  /*!
   * \ja
   * Int8のデータブロックを取り出します。
   * get_sizeに読み込めたデータ数がセットされます。
   * \param block_size ブロックサイズ
   * \param ptr データの保存先
   * \param get_size 読み込んだデータ数
   * \ja_end
   */
  virtual void getInt8Block(Size block_size, Int8* ptr, Size& get_size) CCC_RAISES(IOException);
  /*!
   * \ja
   * UInt16のデータブロックを取り出します。
   * get_sizeに読み込めたデータ数がセットされます。
   * \param block_size ブロックサイズ
   * \param ptr データの保存先
   * \param get_size 読み込んだデータ数
   * \ja_end
   */
  virtual void getUInt16Block(Size block_size, UInt16* ptr, Size& get_size) CCC_RAISES(IOException);
  /*!
   * \ja
   * UInt32のデータブロックを取り出します。
   * get_sizeに読み込めたデータ数がセットされます。
   * \param block_size ブロックサイズ
   * \param ptr データの保存先
   * \param get_size 読み込んだデータ数
   * \ja_end
   */
  virtual void getUInt32Block(Size block_size, UInt32* ptr, Size& get_size) CCC_RAISES(IOException);
  /*!
   * 1行のデータを読み込みます。
   * 行末はLF(0x0a)とし、行末文字も読み込み先文字列に書き込まれます。
   * \param to 読み込み先文字列
   * \param append_p trueを指定すると、読み込み先文字列に読み込んだ文字列を追加します。
   * \retval false ファイルの途中の行を読み込みました。
   * \retval true ファイル最後の行を読み込みました。
   */
  virtual bool getLine(BString* to, bool append_p = false) CCC_RAISES(IOException);
  /*!
   * 1行のデータを読み込みます。
   * 行末はLF(0x0a)とし、行末文字も読み込み先文字列に書き込まれます。
   * \param to 読み込み先文字列
   * \param append_p trueを指定すると、読み込み先文字列に読み込んだ文字列を追加します。
   * \retval false ファイルの途中の行を読み込みました。
   * \retval true ファイル最後の行を読み込みました。
   */
  virtual bool getLine(DString* to, bool append_p = false) CCC_RAISES(IOException);
  /*!
   * 1行のデータを読み込みます。
   * 行末はLF(0x0a)とし、行末文字も読み込み先文字列に書き込まれます。
   * \param to 読み込み先文字列
   * \param append_p trueを指定すると、読み込み先文字列に読み込んだ文字列を追加します。
   * \retval false ファイルの途中の行を読み込みました。
   * \retval true ファイル最後の行を読み込みました。
   */
  virtual bool getLine(WString* to, bool append_p = false) CCC_RAISES(IOException);
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_IFlow_h */
