﻿// $Id$

#ifndef INCLUDE_ccc_base_IOException_h
#define INCLUDE_ccc_base_IOException_h

#include <ccc/base/base.h>
#include <ccc/base/Exception.h>

CCC_NAMESPACE_START(CCC)

/*!
 * I/O 処理に関する例外を表現するクラスです。
 */
class IOException
  : public Exception
{
 public:
  /*!
   * \ja
   * エラーの概要を表現するためのenum型です。
   * \ja_end
   */
  enum ErrorNum
  {
    /*!
     * \ja
     * エラー無し
     * \ja_end
     */
    NOERR,
    /*!
     * \ja
     * 入力フローの終りです。フローの終りを越えて読み出そうとしました。
     * \ja_end
     */
    READ_BEYOND_THE_EOF,
    R_EOF = READ_BEYOND_THE_EOF,
    /*!
     * \ja
     * 出力フローの終りです。フローの終りを越えて書き出そうとしました。
     * \ja_end
     */
    WRITE_BEYOND_THE_EOF,
    W_EOF = WRITE_BEYOND_THE_EOF,
    /*!
     * \ja
     * Flowがオープンされていません。
     * \ja_end
     */
    NOT_OPENED,
    /*!
     * \ja
     * 実装されていないメソッド呼び出しです。
     * \ja_end
     */
    NOT_IMPLEMENTED,
    /*!
     * \ja
     * サポートされていないメソッド呼び出しです。
     * \ja_end
     */
    NOT_SUPPORTED,
    /*!
     * \ja
     * フィルタの入力元が設定されていません。
     * \ja_end
     */
    EMPTY_FILTER_SRC,
    /*!
     * \ja
     * フィルタの出力先が設定されていません。
     * \ja_end
     */
    EMPTY_FILTER_DEST,
    /*!
     * \ja
     * ファイルのエラー
     * \ja_end
     */
    FILE_IO_ERROR,
    /*!
     * \ja
     * フロー間でIOの型が一致せずデータ転送できません。
     * \ja_end
     */
    IOTYPE_MISMATCH,
    /*!
     * \ja
     * 不正な引数が指定されました。
     * \ja_end
     */
    INVALID_ARG,
    /*!
     * \ja
     * タイムアウト
     * \ja_end
     */
    TIMEOUT,
  };

 private:
  /*!
   * \ja
   * エラー番号
   * \ja_end
   */
  ErrorNum num;

 public:
  /*!
   * \ja
   * コンストラクタ
   * \param file_name ファイル名
   * \param line_num 行番号
   * \param num エラー番号
   * \ja_end
   */
  IOException(const char* file_name, int line_num, ErrorNum num)
    : Exception(file_name, line_num)
  {
    IOException::num = num;
  }
  /*!
   * \ja
   * エラー番号を取り出します。
   * \retval エラー番号
   * \ja_end
   */
  ErrorNum errorNum() { return num; }
  /*!
   * \ja
   * エラー番号に対応した文字列を取得します。
   * staticな文字列オブジェクトが返されるので、呼び出し側で
   * メモリを解放したり、内容を書き換えないようにしてください。
   * \return エラー文字列
   * \ja_end
   */
  const char* getErrorString();
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_IOException_h */
