﻿// $Id$

#ifndef INCLUDE_ccc_base_IOType_h
#define INCLUDE_ccc_base_IOType_h

#include <ccc/base/base.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * I/Oが可能な型を表現するのに使用します。
 * I/Oが複数の型をサポートしている場合には、ビット単位で OR した値を用います。
 * \ja_end
 * \en
 * \en_end
 */
enum IOType
{
  IOTYPE_NULL = 0,	//!< no type
  IOTYPE_INT8 = 0x1,	//!< Int8
  IOTYPE_UINT16 = 0x2,	//!< UInt16
  IOTYPE_UINT32 = 0x4,	//!< UInt32
  IOTYPE_ANY = 0x7,	//!< any type (Int8, UInt16, UInt32)
};

/*!
 * IOTypeのenum値をテンプレート経由で参照するためのテンプレート関数です。
 * Tの型にはInt8, UInt16, UInt32のいずれかしか使用できません。
 * \retval テンプレートで指定した型に対するIOTypeの値が返ります。
 */
template <typename T>
IOType ioTypeVal();

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_IOType_h */
