﻿// $Id$

#ifndef INCLUDE_ccc_base_Iterator_h
#define INCLUDE_ccc_base_Iterator_h

#include <ccc/base/base.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * イタレータのインターフェースを提供します。
 * \ja_end
 */
template <class Element>
class Iterator
  : public Object
{
 public:
  /*!
   * \ja
   * コンストラクタ
   * \ja_end
   */
  Iterator() { }
  /*!
   * \ja
   * デストラクタ
   * \ja_end
   */
  virtual ~Iterator() { };
  /*!
   * \ja
   * 現在位置のエレメントへのポインタを返します。
   * \return 指し示しているエレメントへのポインタ
   * \ja_end
   */
  virtual Element* current() const = 0;
  /*!
   * \ja
   * 現在位置のエレメントへのポインタを返し、参照位置を1つ進めます。
   * \return 指し示していたエレメントへのポインタ
   * \ja_end
   */
  virtual Element* next() = 0;
  /*!
   * \ja
   * 現在位置のエレメントへのポインタを返し、参照位置を1つ戻します。
   * \return 指し示していたエレメントへのポインタ
   * \ja_end
   */
  virtual Element* prev() = 0;
  /*!
   * \ja
   * 現在位置を先頭に戻します。
   * \return 先頭のエレメントへのポインタ
   * \ja_end
   */
  virtual Element* rewind() = 0;
  /*!
   * \ja
   * 現在位置を最後まで進めます。
   * \return 最後のエレメントへのポインタ
   * \ja_end
   */
  virtual Element* unwind() = 0;
  /*!
   * \ja
   * 現在位置が有効な位置かどうかを調べます。
   * \retval true 有効な位置
   * \retval false 無効な位置
   * \ja_end
   */
  virtual bool validPositionP() const = 0;
  /*!
   * \ja
   * 先頭から順に数えた現在位置の数字を得ます。
   * \return 現在位置の数字,先頭は1から始まります。
   * \ja_end
   */
  virtual Size getPosition() const = 0;
  /*!
   * \ja
   * イタレーションが終了しているかどうかを調べます。
   * \retval true 終了
   * \retval false まだ終了していない
   * \ja_end
   */
  virtual bool eofP() const { return !validPositionP(); }
};

template <class Element> class Collection;

/*!
 * \ja
 * Iteratorのスマートポインタ
 * Iteratorのオブジェクトをこのクラスを使って管理することで、
 * 破棄忘れや、例外時の処理などが確実に行えるようになります。
 * \ja_end
 */
template <class Element>
class Itr
{
  /*!
   * 管理対象のオブジェクト
   */
  Iterator<Element>* itr;
 public:
  /*!
   * コンストラクタ
   * \param itr 管理対象のオブジェクト
   */
  Itr(Iterator<Element>* itr)
  {
    Itr::itr = itr;
  }
  /*!
   * Iteratorを生成するCollecitonを引数とするコンストラクタ
   * \param col Collection
   */
  Itr(Collection<Element>* col);
  /*!
   * Iteratorを生成するCollecitonを引数とするコンストラクタ
   * \param col Collection
   */
  Itr(Collection<Element>& col);
  /*!
   * デストラクタ
   */
  ~Itr()
  {
    delete itr;
  }
  /*!
   * 管理対象のオブジェクトのポインタを得ます。
   * \return 管理対象のオブジェクト
   */
  Iterator<Element>* operator ->()
  {
    return itr;
  }
  /*!
   * 管理対象のオブジェクトのポインタを得ます。
   * \return 管理対象のオブジェクト
   */
  Iterator<Element>* ref()
  {
    return itr;
  }
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_Iterator_h */
