﻿// $Id$

#ifndef INCLUDE_ccc_base_LinkDict_h
#define INCLUDE_ccc_base_LinkDict_h

#include <ccc/base/Dict.h>
#include <ccc/base/LinkList.h>

CCC_NAMESPACE_START(CCC)

template <class Element, class Key>
class LinkDict			//! LinkDict
  : public Dict<Element, Key>
{
  LinkList<Element> list;

 protected:
  virtual const Key* getKey(const Element* element) const = 0;
  virtual int compare(const Key* key1, const Key* key2) const = 0;

 public:
  LinkDict() { }
  virtual ~LinkDict() { }

  // Collection interface
  virtual bool emptyP() const { return list.emptyP(); }
  virtual Size number() const { return list.number(); }
  virtual bool add(Element* element) { return list.add(element); }
  virtual bool remove(Element* element) { return list.remove(element); }
  virtual void clear() { list.clear(); }
  virtual bool elementP(Element* element) const { return list.elementP(element); }
  virtual Iterator<Element>* createIterator() const { return list.createIterator(); }

  // Set interface
  //virtual bool remove(Set<Element>* s);
  //virtual bool add(Set<Element>* s);

  // Dict interface
  virtual Element* search(const Key* key) const;
};

template <class Element, class Key>
Element*
LinkDict<Element, Key>::search(const Key* key) const
{
  Element* ret = 0;
  Iterator<Element>* itr = createIterator();
  while (itr->validPositionP())
  {
    Element* element = itr->next();
    if (!compareWithElement(element, key))
    {
      ret = element;
      break;
    }
  }
  delete itr;
  return ret;
}

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_LinkDict_h */
