﻿// $Id$

#ifndef INCLUDE_ccc_base_LinkSet_h
#define INCLUDE_ccc_base_LinkSet_h

#include <ccc/base/Set.h>
#include <ccc/base/LinkList.h>

CCC_NAMESPACE_START(CCC)

template <class Element>
class LinkSet			//! LinkSet
  : public Set<Element>
{
  LinkList<Element> list;
  
 public:
  LinkSet() { }
  virtual ~LinkSet() { }

  // Collection interface
  virtual bool emptyP() const { return list.emptyP(); }
  virtual Size number() const { return list.number(); }
  virtual bool add(Element* element) { return list.add(element); }
  virtual bool remove(Element* element) { return list.remove(element); }
  virtual void clear() { list.clear(); }
  virtual bool elementP(Element* element) const { return list.elementP(element); }
  virtual Iterator<Element>* createIterator() const { return list.createIterator(); }

  // Set interface
  //virtual bool remove(Set* s);
  //virtual bool add(Set* s);
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_LinkSet_h */
