﻿// $Id$

#include <ccc/base/MemOFlow.h>

CCC_NAMESPACE_START(CCC)

MemOFlow::MemOFlow(Size initial_size)
  : OFlow(IOTYPE_ANY)
{
  mem = new Allocator(initial_size);
  attached_allocator_p = false;
  setOpened(true);
}

MemOFlow::MemOFlow(Allocator* mem_)
  : OFlow(IOTYPE_ANY)
{
  mem = mem_;
  mem->setUsedSize(0);
  attached_allocator_p = true;
  setOpened(true);
}

MemOFlow::~MemOFlow()
{
  close();
}

Size
MemOFlow::getSize()
{
  if (!mem)
  {
    return 0;
  }
  return mem->getUsedSize();
}

void
MemOFlow::putInt8(Int8 c) CCC_RAISES(IOException)
{
  if (!openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::NOT_OPENED);
  }
  Size n = mem->addUsedSize(sizeof(Int8));
  Int8* x = (Int8*)((UInt8*)getMem() + (n - sizeof(Int8)));
  *x = c;
}

void
MemOFlow::putUInt16(UInt16 c) CCC_RAISES(IOException)
{
  if (!openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::NOT_OPENED);
  }
  Size n = mem->addUsedSize(sizeof(UInt16));
  UInt16* x = (UInt16*)((UInt8*)getMem() + (n - sizeof(UInt16)));
  *x = c;
}

void
MemOFlow::putUInt32(UInt32 c) CCC_RAISES(IOException)
{
  if (!openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::NOT_OPENED);
  }
  Size n = mem->addUsedSize(sizeof(UInt32));
  UInt32* x = (UInt32*)((UInt8*)getMem() + (n - sizeof(UInt32)));
  *x = c;
}

bool
MemOFlow::topP()
{
  if (!mem)
  {
    return false;
  }
  return mem->getUsedSize() == 0;
}

void*
MemOFlow::getMem()
{
  if (!openedP())
  {
    return 0;
  }
  if (!mem)
  {
    return 0;
  }
  return mem->getMem();
}

bool
MemOFlow::rewind()
{
  if (openedP())
  {
    if (!mem)
    {
      return false;
    }
    mem->setUsedSize(0);
    return true;
  }
  else
  {
    return false;
  }
}

bool
MemOFlow::close()
{
  if (!attached_allocator_p)
  {
    delete mem;
    mem = 0;
  }
  return OFlow::close();
}

CCC_NAMESPACE_END(CCC)
