﻿// $Id$

#ifndef INCLUDE_ccc_base_MemOFlow_h
#define INCLUDE_ccc_base_MemOFlow_h

#include <ccc/base/OFlow.h>
#include <ccc/base/Allocator.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * メモリサイズが自動拡張されるメモリ出力フロー
 * \ja_end
 */
class MemOFlow
  : public OFlow
{
  /*!
   * 出力先アロケータ
   */
  Allocator* mem;
  /*!
   * 出力先アロケータが外部から指定された場合には真
   */
  bool attached_allocator_p;

 public:
  /*!
   * \ja
   * コンストラクタ
   * \param initial_size メモリ初期サイズ
   * \ja_end
   */
  MemOFlow(Size initial_size = 10);
  /*!
   * \ja
   * コンストラクタ
   * \param mem 出力先のAllocator
   * \ja_end
   */
  MemOFlow(Allocator* mem);
  /*!
   * \ja
   * デストラクタ
   * \ja_end
   */
  virtual ~MemOFlow();
  /*!
   * \ja
   * OFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual void putInt8(Int8 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * OFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual void putUInt16(UInt16 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * OFlowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual void putUInt32(UInt32 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * メモリの先頭アドレスを取得します。
   * フローを閉じた後は0が返ります。
   * \return メモリ先頭アドレス
   * \ja_end
   */
  void* getMem();
  /*!
   * \ja
   * 使用したメモリのバイト数を取得します。
   * フローを閉じた後は0が返ります。
   * \return バイト数
   * \ja_end
   */
  Size getSize();
  /*!
   * \ja
   * Flowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual bool topP();
  /*!
   * \ja
   * Flowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual bool rewind();
  /*!
   * \ja
   * フローを閉じます。
   * クローズ以降のデータ出力を行うとNOT_OPENEDの例外が発生します。
   * フローがオープンされていなくてもクローズは成功します。
   * 一度閉じたMemOFlowフローを再びオープンすることはできません。
   * \retval true クローズ成功
   * \ja_end
   */
  virtual bool close();
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_MemOFlow_h */
