﻿// $Id$
// Copyright (C) 1992, 1993, 1994, 1999 by T.Kudou. All rights reserved.
// Copyright (C) 2000 CYPAC Co.,Inc. All rights reserved.

#include <ccc/base/NDLinkList.h>

CCC_NAMESPACE_START(CCC);

// ------------------------------------------------------------
// class InnerNDLinkList

void
InnerNDLinkList::push(InnerNDLinkListNode* node)
{
  if (node)
  {
    node->setPrev_(0);
    node->setNext_(getTop());
    if (getTop() != 0)
    {
      getTop()->setPrev_(node);
    }
    else
    {
      setBottom(node);
    }
    setTop(node);
  }
}

void
InnerNDLinkList::push(InnerNDLinkList& list)
{
  if (list.getBottom() != 0)
  {
    list.getBottom()->setNext_(getTop());
    if (getTop() != 0)
    {
      getTop()->setPrev_(list.getBottom());
    }
    else
    {
      setBottom(list.getBottom());
    }
    setTop(list.getTop());
    list.setTop(0);
    list.setBottom(0);
  }
}

InnerNDLinkListNode*
InnerNDLinkList::pop()
{
  InnerNDLinkListNode* node = getTop();
  if (node)
  {
    remove(node);
  }
  return node;
}

void
InnerNDLinkList::inject(InnerNDLinkListNode* node)
{
  if (node)
  {
    node->setPrev_(getBottom());
    node->setNext_(0);
    if (getBottom() != 0)
    {
      getBottom()->setNext_(node);
    }
    else
    {
      setTop(node);
    }
    setBottom(node);
  }
}

void
InnerNDLinkList::inject(InnerNDLinkList& list)
{
  if (list.getTop() != 0)
  {
    list.getTop()->setPrev_(getBottom());
    if (getBottom() != 0)
    {
      getBottom()->setNext_(list.getTop());
    }
    else
    {
      setTop(list.getTop());
    }
    setBottom(list.getBottom());
    list.setTop(0);
    list.setBottom(0);
  }
}

InnerNDLinkListNode*
InnerNDLinkList::eject()
{
  InnerNDLinkListNode* node = getBottom();
  if (node)
  {
    remove(bottom);
  }
  return node;
}

bool
InnerNDLinkList::insertBefore(Size pos, InnerNDLinkListNode* node)
{
  if (!pos || !node)
  {
    return false;
  }
  InnerNDLinkListNode* s = access(pos);
  if (s)
  {
    return insertBefore(s, node);
  }
  return false;
}

bool
InnerNDLinkList::insertBefore(InnerNDLinkListNode* pos, InnerNDLinkListNode* node)
{
  if (!pos || !node)
  {
    return false;
  }
  node->setNext_(pos);
  node->setPrev_(pos->getPrev_());
  if (pos->getPrev_() != 0)
  {
    pos->getPrev_()->setNext_(node);
  }
  else
  {
    setTop(node);
  }
  pos->setPrev_(node);
  return true;
}

bool
InnerNDLinkList::insertAfter(Size pos, InnerNDLinkListNode* node)
{
  if (!pos || !node)
  {
    return false;
  }
  InnerNDLinkListNode* s = access(pos);
  if (s != 0)
  {
    return insertAfter(s, node);
  }
  return false;
}

bool
InnerNDLinkList::insertAfter(InnerNDLinkListNode* pos, InnerNDLinkListNode* node)
{
  if (!pos || !node)
  {
    return false;
  }
  node->setNext_(pos->getNext_());
  node->setPrev_(pos);
  if (pos->getNext_() != 0)
  {
    pos->getNext_()->setPrev_(node);
  }
  else
  {
    setBottom(node);
  }
  pos->setNext_(node);
  return true;
}

bool
InnerNDLinkList::remove(InnerNDLinkListNode* node)
{
  if (!node)
  {
    return false;
  }
  if (node->getPrev_() != 0)
  {
    node->getPrev_()->setNext_(node->getNext_());
  }
  else
  {
    setTop(node->getNext_());
  }
  if (node->getNext_() != 0)
  {
    node->getNext_()->setPrev_(node->getPrev_());
  }
  else
  {
    setBottom(node->getPrev_());
  }
  node->setPrev_(0);
  node->setNext_(0);
  return true;
}

bool
InnerNDLinkList::remove(Size pos)
{
  if (!pos)
  {
    return false;
  }
  InnerNDLinkListNode* node = access(pos);
  if (node)
  {
    return remove(node);
  }
  return false;
}

void
InnerNDLinkList::clear()
{
  InnerNDLinkListNode* s = getTop();
  while (s != 0)
  {
    InnerNDLinkListNode* next = s->getNext_();
    if (deleteNodeP())
    {
      delete s;
    }
    else
    {
      s->setNext_(0);
      s->setPrev_(0);
    }
    s = next;
  }
  setTop(0);
  setBottom(0);
}

bool
InnerNDLinkList::exchangeElement(InnerNDLinkListNode* pos, InnerNDLinkListNode* node)
{
  if (!pos || !node)
  {
    return false;
  }
  node->setPrev_(pos->getPrev_());
  node->setNext_(pos->getNext_());
  if (pos->getPrev_() != 0)
  {
    pos->getPrev_()->setNext_(node);
  }
  else
  {
    setTop(node);
  }
  if (pos->getNext_() != 0)
  {
    pos->getNext_()->setPrev_(node);
  }
  else
  {
    setBottom(node);
  }
  pos->setPrev_(0);
  pos->setNext_(0);
  return true;
}

bool
InnerNDLinkList::exchangeElement(Size pos, InnerNDLinkListNode* node)
{
  if (!pos || !node)
  {
    return false;
  }
  InnerNDLinkListNode* s = access(pos);
  if (s != 0)
  {
    return exchangeElement(s, node);
  }
  return false;
}

bool
InnerNDLinkList::swapElement(InnerNDLinkListNode* i1, InnerNDLinkListNode* i2)
{
  if (!i1 || !i2)
  {
    return false;
  }
  InnerNDLinkListNode* i1_prev = i1->getPrev_();
  InnerNDLinkListNode* i1_next = i1->getNext_();
  InnerNDLinkListNode* i2_prev = i2->getPrev_();
  InnerNDLinkListNode* i2_next = i2->getNext_();
  if (i1_prev == i2)
  {
    // i2_prev, i2, i1, i1_next => i2_prev, i1, i2, i1_next
    if (i2_prev)
    {
      i2_prev->setNext_(i1);
    }
    else
    {
      setTop(i1);
    }
    i1->setPrev_(i2_prev);
    i1->setNext_(i2);
    i2->setPrev_(i1);
    i2->setNext_(i1_next);
    if (i1_next)
    {
      i1_next->setPrev_(i2);
    }
    else
    {
      setBottom(i2);
    }
  }
  else if (i2_prev == i1)
  {
    // i1_prev, i1, i2, i2_next => i1_prev, i2, i1, i2_next
    if (i1_prev)
    {
      i1_prev->setNext_(i2);
    }
    else
    {
      setTop(i2);
    }
    i2->setPrev_(i1_prev);
    i2->setNext_(i1);
    i1->setPrev_(i2);
    i1->setNext_(i2_next);
    if (i2_next)
    {
      i2_next->setPrev_(i1);
    }
    else
    {
      setBottom(i1);
    }
  }
  else
  {
    i1->setPrev_(i2_prev);
    i1->setNext_(i2_next);
    i2->setPrev_(i1_prev);
    i2->setNext_(i1_next);
    if (i1_prev != 0)
    {
      i1_prev->setNext_(i2);
    }
    else
    {
      setTop(i2);
    }
    if (i1_next != 0)
    {
      i1_next->setPrev_(i2);
    }
    else
    {
      setBottom(i2);
    }
    if (i2_prev != 0)
    {
      i2_prev->setNext_(i1);
    }
    else
    {
      setTop(i1);
    }
    if (i2_next != 0)
    {
      i2_next->setPrev_(i1);
    }
    else
    {
      setBottom(i1);
    }
  }
  return true;
}

bool
InnerNDLinkList::swapElement(Size n1, Size n2)
{
  if (!n1 || !n2)
  {
    return false;
  }
  InnerNDLinkListNode* i1 = access(n1);
  InnerNDLinkListNode* i2 = access(n2);
  if (i1 && i2)
  {
    return swapElement(i1, i2);
  }
  return false;
}

bool
InnerNDLinkList::removeAllBefore(Size pos)
{
  if (!pos)
  {
    return false;
  }
  InnerNDLinkListNode* node = access(pos);
  if (!node)
  {
    return false;
  }
  return removeAllBefore(node);
}

bool
InnerNDLinkList::removeAllBefore(InnerNDLinkListNode* pos)
{
  if (!pos)
  {
    return false;
  }
  InnerNDLinkListNode* node = getTop();
  if (deleteNodeP())
  {
    while (node != 0)
    {
      InnerNDLinkListNode* next = node->getNext_();
      if (node != pos)
      {
	delete node;
      }
      else
      {
	setTop(pos);
	return true;
      }
      node = next;
    }
  }
  else
  {
    while (node != 0)
    {
      InnerNDLinkListNode* next = node->getNext_();
      if (node != pos)
      {
	node->setNext_(0);
	node->setPrev_(0);
      }
      else
      {
	setTop(pos);
	return true;
      }
      node = next;
    }
  }
  return false;
}

bool
InnerNDLinkList::removeAllAfter(Size pos)
{
  if (!pos)
  {
    return false;
  }
  InnerNDLinkListNode* node = access(pos);
  if (!node)
  {
    return false;
  }
  return removeAllAfter(node);
}

bool
InnerNDLinkList::removeAllAfter(InnerNDLinkListNode* pos)
{
  if (!pos)
  {
    return false;
  }
  InnerNDLinkListNode* node = pos->getNext_();
  if (deleteNodeP())
  {
    while (node)
    {
      InnerNDLinkListNode* next = node->getNext_();
      delete node;
      node = next;
    }
  }
  else
  {
    while (node)
    {
      InnerNDLinkListNode* next = node->getNext_();
      node->setNext_(0);
      node->setPrev_(0);
      node = next;
    }
  }
  pos->setNext_(0);
  setBottom(pos);
  return true;
}

bool
InnerNDLinkList::removeAllBetween(Size pos1, Size pos2)
{
  if (!pos1 || !pos2)
  {
    return false;
  }
  Size beg_pos = pos1;
  Size end_pos = pos2;
  if (pos1 > pos2)
  {
    beg_pos = pos2;
    end_pos = pos1;
  }
  InnerNDLinkListNode* node1 = access(beg_pos);
  InnerNDLinkListNode* node2 = access(end_pos);
  if (!node1 || !node2)
  {
    return false;
  }
  return removeAllBetweenX(node1, node2);
}

bool
InnerNDLinkList::removeAllBetween(InnerNDLinkListNode* pos1,
						InnerNDLinkListNode* pos2)
{
  if (!pos1 || !pos2)
  {
    return false;
  }
  InnerNDLinkListNode* node = pos1;
  while (node) 
  {
    if (node == pos2)
    {
      return removeAllBetweenX(pos1, pos2);
    }
    node = node->getNext_();
  }
  return removeAllBetweenX(pos2, pos1);
}

// This method doesn't check pos_beg and pos_end order.
bool
InnerNDLinkList::removeAllBetweenX(InnerNDLinkListNode* rm_beg, InnerNDLinkListNode* rm_end)
{
  InnerNDLinkListNode* node = rm_beg;
  InnerNDLinkListNode* prev = rm_beg->getPrev_();
  if (deleteNodeP())
  {
    while (node)
    {
      InnerNDLinkListNode* next = node->getNext_();
      delete node;
      if (node == rm_end)
      {
	if (prev)
	{
	  prev->setNext_(next);
	}
	else
	{
	  setTop(next);
	}
	if (next)
	{
	  next->setPrev_(prev);
	}
	else
	{
	  setBottom(prev);
	}
	return true;
      }
      node = next;
    }
  }
  else
  {
    while (node)
    {
      InnerNDLinkListNode* next = node->getNext_();
      node->setNext_(0);
      node->setPrev_(0);
      if (node == rm_end)
      {
	if (prev)
	{
	  prev->setNext_(next);
	}
	else
	{
	  setTop(next);
	}
	if (next)
	{
	  next->setPrev_(prev);
	}
	else
	{
	  setBottom(prev);
	}
	return true;
      }
      node = next;
    }
  }
  return false;
}

// ------------------------------------------------------------
// class InnerNDLinkListIterator

InnerNDLinkListIterator::InnerNDLinkListIterator(const InnerNDLinkList* l)
 : InnerIterator(l)
{
  node = getFirst();
}

InnerNDLinkListNode* 
InnerNDLinkListIterator::current() const
{
  return node;
}

InnerNDLinkListNode* 
InnerNDLinkListIterator::next()
{
  InnerNDLinkListNode* ret = node;
  if (node)
  {
    node = node->getNext_();
  }
  return ret;
}

InnerNDLinkListNode* 
InnerNDLinkListIterator::prev()
{
  InnerNDLinkListNode* ret = node;
  if (node)
  {
    node = node->getPrev_();
  }
  return ret;
}

InnerNDLinkListNode* 
InnerNDLinkListIterator::rewind()
{
  node = getFirst();
  return node;
}

InnerNDLinkListNode* 
InnerNDLinkListIterator::unwind()
{
  node = getLast();
  return node;
}

bool 
InnerNDLinkListIterator::validPositionP() const
{
  return node ? true : false;
}

Size 
InnerNDLinkListIterator::getPosition() const
{
  if (!node)
  {
    return 0;
  }
  InnerNDLinkListNode* n = getFirst();
  Size pos = 0;
  while (n)
  {
    pos++;
    if (n == node)
    {
      return pos;
    }
  }
  return 0;
}

CCC_NAMESPACE_END(CCC);
