﻿// $Id$
// Copyright (C) 1992, 1993, 1994, 1999 by T.Kudou. All rights reserved.
// Copyright (C) 2000 CYPAC Co.,Inc. All rights reserved.

#ifndef INCLUDE_ccc_base_NDLinkList_h
#define INCLUDE_ccc_base_NDLinkList_h

// eNdogenous double pointer list

#include <ccc/base/NLinkList.h>

CCC_NAMESPACE_START(CCC)

class InnerNDLinkListNode	//! InnerNDLinkListNode
  : public InnerNLinkListNode
{
  InnerNDLinkListNode* prev;

 public:
  InnerNDLinkListNode(InnerNDLinkListNode* prev, InnerNDLinkListNode* next)
   : InnerNLinkListNode(next) { InnerNDLinkListNode::prev = prev; }
  virtual ~InnerNDLinkListNode() { ; }
  InnerNDLinkListNode* getNext_() const { return (InnerNDLinkListNode*)InnerNLinkListNode::getNext_(); }
  void setNext_(InnerNDLinkListNode* n) { InnerNLinkListNode::setNext_(n); }
  InnerNDLinkListNode* getPrev_() const { return prev; }
  void setPrev_(InnerNDLinkListNode* p) { prev = p; }
  void set(InnerNDLinkListNode* prev, InnerNDLinkListNode* next)
  {
    setPrev_(prev);
    setNext_(next);
  }
};

#ifdef HAS_STATIC_CAST
#define INNER_SNODE_CAST(X) static_cast<InnerNLinkListNode*>(X)
#else /* HAS_STATIC_CAST */
#define INNER_SNODE_CAST(X) (InnerNLinkListNode*)(X)
#endif /* HAS_STATIC_CAST */

class InnerNDLinkList		//! InnerNDLinkList
  : public InnerNLinkList
{
  InnerNDLinkListNode* bottom;

 public:
  InnerNDLinkListNode* getBottom() const { return bottom; }
  void setBottom(InnerNDLinkListNode* node) { bottom = node; }
  InnerNDLinkListNode* getTop() const
  { return (InnerNDLinkListNode*)InnerNLinkList::getTop(); }
  void setTop(InnerNDLinkListNode* node) { InnerNLinkList::setTop(INNER_SNODE_CAST(node)); }

  InnerNDLinkList(bool delete_node_p_) : InnerNLinkList(delete_node_p_) { bottom = 0; }
  ~InnerNDLinkList() { ; }
  bool emptyP() const { return InnerNLinkList::emptyP(); }
  Size number() const { return InnerNLinkList::number(); }
  void clear();
  InnerNDLinkListNode* access(Size n) const
    { return (InnerNDLinkListNode*)InnerNLinkList::access(n); }
  Size getPosition(InnerNDLinkListNode* node) const
    { return InnerNLinkList::getPosition(INNER_SNODE_CAST(node)); }

  InnerNDLinkListNode* prev(InnerNDLinkListNode* node) const
    { return(node != 0) ? node->getPrev_() : 0; }
  InnerNDLinkListNode* next(InnerNDLinkListNode* node) const
    { return(node != 0) ? node->getNext_() : 0; }
  InnerNDLinkListNode* head() const
  { return(InnerNDLinkListNode*)InnerNLinkList::head(); } const
  InnerNDLinkListNode* tail() const { return bottom; }
  bool elementP(InnerNDLinkListNode* node) const
  { return InnerNLinkList::elementP(INNER_SNODE_CAST(node)); }

  void push(InnerNDLinkListNode* node);
  void push(InnerNDLinkList& node);
  InnerNDLinkListNode* pop();
  void inject(InnerNDLinkListNode* node);
  void inject(InnerNDLinkList& list);
  InnerNDLinkListNode* eject();

  bool insertBefore(Size pos, InnerNDLinkListNode* node);
  bool insertBefore(InnerNDLinkListNode* pos, InnerNDLinkListNode* node);
  bool insertAfter(Size pos, InnerNDLinkListNode* node);
  bool insertAfter(InnerNDLinkListNode* pos, InnerNDLinkListNode* node);
  bool remove(InnerNDLinkListNode* node);
  bool remove(Size pos);
  bool exchangeElement(InnerNDLinkListNode* pos, InnerNDLinkListNode* node);
  bool exchangeElement(Size pos, InnerNDLinkListNode* node);
  bool swapElement(InnerNDLinkListNode* i1, InnerNDLinkListNode* i2);
  bool swapElement(Size n1, Size n2);

  bool removeAllBefore(Size pos);
  bool removeAllBefore(InnerNDLinkListNode* pos);
  bool removeAllAfter(Size pos);
  bool removeAllAfter(InnerNDLinkListNode* pos);
  bool removeAllBetween(Size pos1, Size pos2);
  bool removeAllBetween(InnerNDLinkListNode* pos1,
			InnerNDLinkListNode* pos2);

 private:
  bool removeAllBetweenX(InnerNDLinkListNode* rm_beg,
			 InnerNDLinkListNode* rm_end);

#undef INNER_SNODE_CAST

};

class InnerNDLinkListIterator
  : public InnerIterator
{
  InnerNDLinkListNode* node;

 private:
  const InnerNDLinkList* getInnerNDLinkList() const
  { return (const InnerNDLinkList*)getInnerList(); }
  InnerNDLinkListNode* getFirst() const
  { return getInnerNDLinkList()->getTop(); }
  InnerNDLinkListNode* getLast() const
  { return getInnerNDLinkList()->getBottom(); }
    
 public:
  InnerNDLinkListIterator(const InnerNDLinkList* l);
  InnerNDLinkListNode* current() const;
  InnerNDLinkListNode* next();
  InnerNDLinkListNode* prev();
  InnerNDLinkListNode* rewind();
  InnerNDLinkListNode* unwind();
  bool validPositionP() const;
  Size getPosition() const; // valid position: return >= 1
};

/*!
 * \brief NDLinkListNode
 *
 * template version<br>
 * CAUTION: class Element must be derived from NDLinkListNode
 */
template <class Element>
class NDLinkListNode
  : public InnerNDLinkListNode
{
 public:
  NDLinkListNode(Element* prev = 0, Element* next = 0)
   : InnerNDLinkListNode((InnerNDLinkListNode*)((NDLinkListNode<Element>*)prev),
				       (InnerNDLinkListNode*)((NDLinkListNode<Element>*)next)) { ; }
  virtual ~NDLinkListNode() { ; }
  Element* getNext() const
  { return(Element*)((NDLinkListNode<Element>*)InnerNDLinkListNode::getNext_()); }
  void setNext(Element* next)
  { InnerNDLinkListNode::setNext_((InnerNDLinkListNode*)((NDLinkListNode<Element>*)next)); }
  Element* getPrev() const
  { return(Element*)((NDLinkListNode<Element>*)InnerNDLinkListNode::getPrev_()); }
  void setPrev(Element* next)
  { InnerNDLinkListNode::setPrev_((InnerNDLinkListNode*)((NDLinkListNode<Element>*)next)); }
};

template <class Element>
class NDLinkList		//! NDLinkList
  : public List<Element>
{
  InnerNDLinkList inll;
  
 public:
  const InnerNDLinkList* getInnerNDLinkList() const { return &inll; }

  NDLinkList(bool delete_node_p = false) : inll(delete_node_p) { }
  virtual ~NDLinkList() { };

#ifdef HAS_STATIC_CAST
#define INNER_DNODE_CAST(X) static_cast<InnerNDLinkListNode*>(X)
#else /* HAS_STATIC_CAST */
#define INNER_DNODE_CAST(X) (InnerNDLinkListNode*)(X)
#endif /* HAS_STATIC_CAST */

  // Collection interface
  virtual bool emptyP() const { return inll.emptyP(); }
  virtual Size number() const { return inll.number(); }
  virtual bool add(Element* element) { inll.inject(INNER_DNODE_CAST(element)); return true; }
  virtual void clear() { inll.clear(); }
  virtual bool elementP(Element* element) const { return inll.elementP(INNER_DNODE_CAST(element)); }
  virtual Iterator<Element>* createIterator() const;

  // List interface
  //void assign(NDLinkList& l) { inll.assign(l.inll); }
  void operator = (NDLinkList& l) { assign(l); };
  virtual Element* vector(Size vec_pos) const { return (Element*)inll.access(vec_pos + 1); }
  virtual Size getPosition(Element* element) const { return inll.getPosition(INNER_DNODE_CAST(element)); }
  virtual Element* prev(Element* element) const { return (Element*)inll.prev(INNER_DNODE_CAST(element)); }
  virtual Element* next(Element* element) const { return (Element*)inll.next(INNER_DNODE_CAST(element)); }
  virtual Element* head() const { return (Element*)inll.head(); }
  virtual Element* tail() const { return (Element*)inll.tail(); }
  // single element operations
  virtual void push(Element* element) { inll.push(INNER_DNODE_CAST(element)); }
  virtual Element* pop() { return (Element*)inll.pop(); }
  virtual void inject(Element* element) { inll.inject(INNER_DNODE_CAST(element)); }
  virtual Element* eject() { return (Element*)inll.eject(); }
  virtual bool insertBefore(Size pos, Element* element) { return inll.insertBefore(pos, INNER_DNODE_CAST(element)); }
  virtual bool insertBefore(Element* pos, Element* element) { return inll.insertBefore(INNER_DNODE_CAST(pos), INNER_DNODE_CAST(element)); }
  virtual bool insertAfter(Size pos, Element* element) { return inll.insertAfter(pos, INNER_DNODE_CAST(element)); }
  virtual bool insertAfter(Element* pos, Element* element) { return inll.insertAfter(INNER_DNODE_CAST(pos), INNER_DNODE_CAST(element)); }
  virtual bool remove(Element* pos) { return inll.remove(INNER_DNODE_CAST(pos)); }
  virtual bool remove(Size pos) { return inll.remove(pos); }
  virtual bool exchangeElement(Size pos, Element* element) { return inll.exchangeElement(pos, INNER_DNODE_CAST(element)); }
  virtual bool exchangeElement(Element* pos, Element* element) { return inll.exchangeElement(INNER_DNODE_CAST(pos), INNER_DNODE_CAST(element)); }
  virtual bool swapElement(Element* i1, Element* i2) { return inll.swapElement(INNER_DNODE_CAST(i1), INNER_DNODE_CAST(i2)); }
  virtual bool swapElement(Size n1, Size n2){ return inll.swapElement(n1, n2); }
  virtual bool removeAllBefore(Size pos) { return inll.removeAllBefore(pos); }
  virtual bool removeAllBefore(Element* pos) { return inll.removeAllBefore(INNER_DNODE_CAST(pos)); }
  virtual bool removeAllAfter(Size pos) { return inll.removeAllAfter(pos); }
  virtual bool removeAllAfter(Element* pos) { return inll.removeAllAfter(INNER_DNODE_CAST(pos)); }
  virtual bool removeAllBetween(Size pos1, Size pos2) { return inll.removeAllBetween(pos1, pos2); }
  virtual bool removeAllBetween(Element* pos1, Element* pos2) { return inll.removeAllBetween(INNER_DNODE_CAST(pos1), INNER_DNODE_CAST(pos2)); }

  // MISC
  void setDeleteNodeP(bool p) { inll.setDeleteNodeP(p); }
#undef INNER_DNODE_CAST
};

template <class Element>
class NDLinkListIterator
  : public Iterator<Element>
{
  InnerNDLinkListIterator inli;

 public:
  NDLinkListIterator(const InnerNDLinkList* l) : inli(l) { }
  NDLinkListIterator(const InnerNDLinkList& l) : inli(&l) { }
  NDLinkListIterator(const NDLinkList<Element>* l) : inli(l->getInnerNDLinkList()) { }
  NDLinkListIterator(const NDLinkList<Element>& l) : inli(l.getInnerLinkList()) { }
  ~NDLinkListIterator() { }
  Element* current() const { return (Element*)inli.current(); }
  Element* next() { return (Element*)inli.next(); }
  Element* prev() { return (Element*)inli.prev(); }
  Element* rewind() { return (Element*)inli.rewind(); }
  Element* unwind() { return (Element*)inli.unwind(); }
  bool validPositionP() const { return inli.validPositionP(); }
  Size getPosition() const { return inli.getPosition(); }
};

template <class Element>
Iterator<Element>*
NDLinkList<Element>::createIterator() const
{
  return new NDLinkListIterator<Element>(this);
}

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_NDLinkList_h */
