﻿// $Id$
// Copyright (C) 1992, 1993, 1994, 1999 by T.Kudou. All rights reserved.
// Copyright (C) 2000 CYPAC Co.,Inc. All rights reserved.

#include <ccc/base/NLinkList.h>

CCC_NAMESPACE_START(CCC);

// ------------------------------------------------------------
// class InnerNLinkList

InnerNLinkList::InnerNLinkList(bool delete_node_p_)
{
  top = 0;
  delete_node_p = delete_node_p_;
}

InnerNLinkList::~InnerNLinkList()
{
  clear();
}

Size
InnerNLinkList::number() const
{
  Size n = 0;
  for (InnerNLinkListNode* s = top; s != 0; s = s->getNext_())
  {
    n++;
  }
  return n;
}

InnerNLinkListNode*
InnerNLinkList::access(Size n) const
{
  Size i = 0;
  for (InnerNLinkListNode* s = top; s != 0; s = s->getNext_())
  {
    if (++i == n)
    {
      return s;
    }
  }
  return 0;
}

Size
InnerNLinkList::getPosition(InnerNLinkListNode* element) const
{
  Size i = 0;
  for (InnerNLinkListNode* s = top;
       s != 0;
       s = s->getNext_())
  {
    i++;
    if (s == element)
    {
      return i;
    }
  }
  return 0;
}

InnerNLinkListNode*
InnerNLinkList::prev(InnerNLinkListNode* node) const
{
  InnerNLinkListNode* prev = 0;
  for (InnerNLinkListNode* s = top; s != 0; s = s->getNext_())
  {
    if (s == node)
    {
      return prev;
    }
    prev = s;
  }
  return 0;
}

InnerNLinkListNode*
InnerNLinkList::tail() const
{
  InnerNLinkListNode* prev = 0;
  for (InnerNLinkListNode* s = top; s != 0; s = s->getNext_())
  {
    prev = s;
  }
  return prev;
}

void
InnerNLinkList::push(InnerNLinkListNode* node)
{
  if (node)
  {
    node->setNext_(top);
    top = node;
  }
}

void
InnerNLinkList::push(InnerNLinkList& list)
{
  InnerNLinkListNode* tail = list.tail();
  if (tail)
  {
    tail->setNext_(top);
    top = list.head();
    list.setTop(0);
  }
  else
  {
    top = list.head();
    list.setTop(0);
  }
}

InnerNLinkListNode*
InnerNLinkList::pop()
{
  InnerNLinkListNode* ret = top;
  if (ret)
  {
    top = top->getNext_();
    ret->unlink();
  }
  return ret;
}

void
InnerNLinkList::inject(InnerNLinkListNode* node)
{
  if (node)
  {
    InnerNLinkListNode* tail_node = tail();
    if (tail_node)
    {
      tail_node->setNext_(node);
    }
    else
    {
      top = node;
    }
    node->setNext_(0);
  }
}

void
InnerNLinkList::inject(InnerNLinkList& list)
{
  InnerNLinkListNode* tail_node = tail();
  InnerNLinkListNode* list_head = list.head();
  if (list_head != 0)
  {
    if (tail_node != 0)
    {
      tail_node->setNext_(list_head);
    }
    else
    {
      top = list_head;
    }
  }
  list.setTop(0);
}

InnerNLinkListNode*
InnerNLinkList::eject()
{
  InnerNLinkListNode* prev = 0;
  for (InnerNLinkListNode* s = top; s != 0; s = s->getNext_())
  {
    if (s->getNext_() == 0)
    { 
      if (prev)
      {
	prev->setNext_(0);
      }
      else
      {
	top = 0;
      }
      s->unlink();
      return s;
    }
    prev = s;
  }
  return 0;
}

bool
InnerNLinkList::insertBefore(Size pos, InnerNLinkListNode* node)
{
  if (!pos || !node)
  {
    return false;
  }
  Size i = 0;
  InnerNLinkListNode* prev = 0;
  for (InnerNLinkListNode* s = top; s != 0; s = s->getNext_())
  {
    if (++i == pos)
    {
      if (prev != 0)
      {
	node->setNext_(prev->getNext_());
	prev->setNext_(node);
      }
      else 
      {
	node->setNext_(top);
	top = node;
      }
      return true;
    }
    prev = s;
  }
  return false;
}

bool
InnerNLinkList::insertBefore(InnerNLinkListNode* pos, InnerNLinkListNode* node)
{
  if (!pos || !node)
  {
    return false;
  }
  InnerNLinkListNode* prev = 0;
  for (InnerNLinkListNode* s = top; s != 0; s = s->getNext_())
  {
    if (s == pos)
    {
      if (prev != 0)
      {
	node->setNext_(prev->getNext_());
	prev->setNext_(node);
      }
      else 
      {
	node->setNext_(top);
	top = node;
      }
      return true;
    }
    prev = s;
  }
  return false;
}

bool
InnerNLinkList::insertAfter(Size pos, InnerNLinkListNode* node)
{
  if (!pos || !node)
  {
    return false;
  }
  Size i = 0;
  for (InnerNLinkListNode* s = top; s != 0; s = s->getNext_())
  {
    if (++i == pos)
    {
      node->setNext_(s->getNext_());
      s->setNext_(node);
      return true;
    }
  }
  return false;
}

bool
InnerNLinkList::insertAfter(InnerNLinkListNode* pos, InnerNLinkListNode* node)
{
  if (!pos || !node)
  {
    return false;
  }
  for (InnerNLinkListNode* s = top; s != 0; s = s->getNext_())
  {
    if (s == pos)
    {
      node->setNext_(s->getNext_());
      s->setNext_(node);
      return true;
    }
  }
  return false;
}

bool
InnerNLinkList::remove(InnerNLinkListNode* node)
{
  if (!node)
  {
    return false;
  }
  InnerNLinkListNode* prev = 0;
  for (InnerNLinkListNode* s = top; s != 0; s = s->getNext_())
  {
    if (s == node)
    {
      if (prev != 0)
      {
	prev->setNext_(s->getNext_());
      }
      else
      {
	top = s->getNext_();
      }
      node->unlink();
      return true;
    }
    prev = s;
  }
  return false;
}

bool
InnerNLinkList::remove(Size pos)
{
  if (!pos)
  {
    return false;
  }
  Size i = 0;
  InnerNLinkListNode* prev = 0;
  for (InnerNLinkListNode* s = top; s != 0; s = s->getNext_())
  {
    if (++i == pos)
    {
      if (prev != 0)
      {
	prev->setNext_(s->getNext_());
      }
      else
      {
	top = s->getNext_();
      }
      s->unlink();
      return true;
    }
    prev = s;
  }
  return false;
}

void
InnerNLinkList::clear()
{
  InnerNLinkListNode* s = top;
  if (delete_node_p)
  {
    while (s != 0)
    {
      InnerNLinkListNode* next = s->getNext_();
      delete s;
      s = next;
    }
  }
  else
  {
    while (s != 0)
    {
      InnerNLinkListNode* next = s->getNext_();
      s->setNext_(0);
      s = next;
    }
  }
  top = 0;
}

bool
InnerNLinkList::exchangeElement(InnerNLinkListNode* pos, InnerNLinkListNode* node)
{
  if (!pos || !node)
  {
    return false;
  }
  InnerNLinkListNode* prev = 0;
  for (InnerNLinkListNode* s = top; s != 0; s = s->getNext_())
  {
    if (s == pos)
    {
      if (prev != 0)
      {
	prev->setNext_(node);
      }
      else
      {
	top = node; 
      }
      node->setNext_(s->getNext_());
      pos->unlink();
      return true;
    }
    prev = s;
  }
  return false;
}

bool
InnerNLinkList::exchangeElement(Size pos, InnerNLinkListNode* node)
{
  if (!pos || !node)
  {
    return false;
  }
  Size i = 0;
  InnerNLinkListNode* prev = 0;
  for (InnerNLinkListNode* s = top; s != 0; s = s->getNext_())
  {
    if (++i == pos)
    {
      if (prev != 0)
      {
	prev->setNext_(node);
      }
      else
      {
	top = node; 
      }
      node->setNext_(s->getNext_());
      s->unlink();
      return true;
    }
    prev = s;
  }
  return false;
}

bool
InnerNLinkList::swapElement(InnerNLinkListNode* i1, InnerNLinkListNode* i2,
					   InnerNLinkListNode* i1_prev, InnerNLinkListNode* i2_prev)
{
  InnerNLinkListNode* n0 = 0;
  InnerNLinkListNode* n1 = 0;
  InnerNLinkListNode* n2 = 0;
  InnerNLinkListNode* n3 = 0;
  if (i2_prev == i1)
  {
    n0 = i1_prev;
    n1 = i2;
    n2 = i1;
    n3 = i2->getNext_();
  }
  if (i1_prev == i2)
  {
    n0 = i2_prev;
    n1 = i1;
    n2 = i2;
    n3 = i1->getNext_();
  }
  if (n1)
  {
    if (n0)
    {
      n0->setNext_(n1);
    }
    else
    {
      top = n1;
    }
    n1->setNext_(n2);
    n2->setNext_(n3);
  }
  else
  {
    InnerNLinkListNode* i1_next = i1->getNext_();
    InnerNLinkListNode* i2_next = i2->getNext_();
    if (i1_prev)
    {
      i1_prev->setNext_(i2);
    }
    else
    {
      top = i2;
    }
    i2->setNext_(i1_next);
    if (i2_prev)
    {
      i2_prev->setNext_(i1);
    }
    else
    {
      top = i1;
    }
    i1->setNext_(i2_next);
  }
  return true;
}

bool
InnerNLinkList::swapElement(InnerNLinkListNode* i1, InnerNLinkListNode* i2)
{
  if (!i1 || !i2)
  {
    return false;
  }
  if (i1 == i2)
  {
    return true;
  }
  InnerNLinkListNode* prev = 0;
  InnerNLinkListNode* i1_prev = 0;
  InnerNLinkListNode* i2_prev = 0;
  bool i1_prev_fix_p = false;
  bool i2_prev_fix_p = false;
  for (InnerNLinkListNode* s = top; s != 0; s = s->getNext_())
  {
    if (s == i1)
    {
      i1_prev = prev;
      i1_prev_fix_p = true; 
    }
    if (s == i2)
    {
      i2_prev = prev;
      i2_prev_fix_p = true;
    }
    if (i1_prev_fix_p && i2_prev_fix_p)
    {
      break;
    }
    prev = s;
  }
  if (i1_prev_fix_p && i2_prev_fix_p)
  {
    return swapElement(i1, i2, i1_prev, i2_prev);
  }
  return false;
}

bool
InnerNLinkList::swapElement(Size n1, Size n2)
{
  if (!n1 || !n2)
  {
    return false;
  }
  if (n1 == n2)
  {
    return true;
  }
  InnerNLinkListNode* prev = 0;
  InnerNLinkListNode* i1 = 0;
  InnerNLinkListNode* i2 = 0;
  InnerNLinkListNode* i1_prev = 0;
  InnerNLinkListNode* i2_prev = 0;
  Size i = 0;
  for (InnerNLinkListNode* s = top; s != 0; s = s->getNext_())
  {
    if (++i == n1)
    {
      i1 = s;
      i1_prev = prev;
    }
    if (i == n2)
    {
      i2 = s;
      i2_prev = prev;
    }
    if (i1 != 0 && i2 != 0)
    {
      break;
    }
    prev = s;
  }
  if (i1 != 0 && i2 != 0)
  {
    return swapElement(i1, i2, i1_prev, i2_prev);
  }
  return false;
}

bool
InnerNLinkList::elementP(InnerNLinkListNode* node) const
{
  for (InnerNLinkListNode* s = top; s != 0; s = s->getNext_())
  {
    if (s == node)
    {
      return true;
    }
  }
  return false;
}

bool
InnerNLinkList::removeAllBefore(Size pos)
{
  if (!pos)
  {
    return false;
  }
  InnerNLinkListNode* node = access(pos);
  if (!node)
  {
    return false;
  }
  return removeAllBefore(node);
}

bool
InnerNLinkList::removeAllBefore(InnerNLinkListNode* pos)
{
  if (!pos)
  {
    return false;
  }
  InnerNLinkListNode* node = top;
  if (delete_node_p)
  {
    while (node != 0)
    {
      InnerNLinkListNode* next = node->getNext_();
      if (node != pos)
      {
	delete node;
      }
      else
      {
	top = pos;
	return true;
      }
      node = next;
    }
  }
  else
  {
    while (node != 0)
    {
      InnerNLinkListNode* next = node->getNext_();
      if (node != pos)
      {
	node->setNext_(0);
      }
      else
      {
	top = pos;
	return true;
      }
      node = next;
    }
  }
  return false;
}

bool
InnerNLinkList::removeAllAfter(Size pos)
{
  if (!pos)
  {	
    return false;
  }
  InnerNLinkListNode* node = access(pos);
  if (!node)
  {
    return false;
  }
  return removeAllAfter(node);
}

bool
InnerNLinkList::removeAllAfter(InnerNLinkListNode* pos)
{
  if (!pos)
  {
    return false;
  }
  InnerNLinkListNode* node = pos->getNext_();
  if (delete_node_p)
  {
    while (node)
    {
      InnerNLinkListNode* next = node->getNext_();
      delete node;
      node = next;
    }
  }
  else
  {
    while (node)
    {
      InnerNLinkListNode* next = node->getNext_();
      node->setNext_(0);
      node = next;
    }
  }
  pos->setNext_(0);
  return true;
}

bool
InnerNLinkList::removeAllBetween(Size pos1, Size pos2)
{
  if (!pos1 || !pos2)
  {
    return false;
  }
  Size beg_pos = pos1;
  Size end_pos = pos2;
  if (pos1 > pos2)
  {
    beg_pos = pos2;
    end_pos = pos1;
  }
  InnerNLinkListNode* node1 = access(beg_pos);
  InnerNLinkListNode* node2 = access(end_pos);
  if (!node1 || !node2)
  {
    return false;
  }
  return removeAllBetweenX(node1, node2);
}

bool
InnerNLinkList::removeAllBetween(InnerNLinkListNode* pos1, InnerNLinkListNode* pos2)
{
  if (!pos1 || !pos2)
  {
    return false;
  }

  InnerNLinkListNode* node = pos1;
  while (node) 
  {
    if (node == pos2)
    {
      return removeAllBetweenX(pos1, pos2);
    }
    node = node->getNext_();
  }
  return removeAllBetweenX(pos2, pos1);
}

// This method doesn't check pos_beg and pos_end order.
bool
InnerNLinkList::removeAllBetweenX(InnerNLinkListNode* rm_beg, InnerNLinkListNode* rm_end)
{
  InnerNLinkListNode* node = top;
  InnerNLinkListNode* prev = 0;
  while (node)
  {
    if (node == rm_beg)
    {
      break;
    }
    prev = node;
    node = node->getNext_();
  }
  if (delete_node_p)
  {
    while (node)
    {
      InnerNLinkListNode* next = node->getNext_();
      delete node;
      if (node == rm_end)
      {
	if (prev)
	{
	  prev->setNext_(next);
	}
	else
	{
	  top = next;
	}
	return true;
      }
      node = next;
    }
  }
  else
  {
    while (node)
    {
      InnerNLinkListNode* next = node->getNext_();
      node->setNext_(0);
      if (node == rm_end)
      {
	if (prev)
	{
	  prev->setNext_(next);
	}
	else
	{
	  top = next;
	}
	return true;
      }
      node = next;
    }
  }
  return false;
}

// ------------------------------------------------------------
// class InnerEndogenousSingleLinkIterator

InnerNLinkListNode*
InnerNLinkListIterator::getLast() const
{
  InnerNLinkListNode* n = getFirst();
  InnerNLinkListNode* prev = 0;
  while (n)
  {
    prev = n;
    n = n->getNext_();
  }
  return prev;
}

InnerNLinkListIterator::InnerNLinkListIterator(const InnerNLinkList* l)
 : InnerIterator(l)
{
  node = getFirst();
}

InnerNLinkListNode*
InnerNLinkListIterator::current() const
{
  return node;
}

InnerNLinkListNode*
InnerNLinkListIterator::next()
{
  InnerNLinkListNode* ret = node;
  if (node)
  {
    node = node->getNext_();
  }
  return ret;
}

InnerNLinkListNode*
InnerNLinkListIterator::prev()
{
  if (node)
  {
    InnerNLinkListNode* ret = node;
    InnerNLinkListNode* n = getFirst();
    InnerNLinkListNode* prev = 0;
    while (n)
    {
      if (node == n)
      {
	node = prev;
	return ret;
      }
      prev = n;
      n = n->getNext_();
    }
  }
  return 0;
}

InnerNLinkListNode*
InnerNLinkListIterator::rewind()
{
  node = getFirst();
  return node;
}

InnerNLinkListNode*
InnerNLinkListIterator::unwind()
{
  node = getLast();
  return node;
}

bool
InnerNLinkListIterator::validPositionP() const
{
  return node ? true : false;
}

Size
InnerNLinkListIterator::getPosition() const
{
  if (!node)
  {
    return 0;
  }
  InnerNLinkListNode* n = getFirst();
  Size pos = 0;
  while (n)
  {
    pos++;
    if (n == node)
    {
      return pos;
    }
  }
  return 0;
}

CCC_NAMESPACE_END(CCC);
