﻿// $Id$
// Copyright (C) 1992, 1993, 1994, 1999 by T.Kudou. All rights reserved.
// Copyright (C) 2000 CYPAC Co.,Inc. All rights reserved.

#ifndef INCLUDE_ccc_base_NLinkList_h
#define INCLUDE_ccc_base_NLinkList_h

#include <ccc/base/List.h>

CCC_NAMESPACE_START(CCC)

// template <class Element> class NLinkList;
// template <class Element> class NLinkListIterator;
//
//! \class NLinkList
//! eNdogenous single pointer list
//!
//! \verbatim
//! top -->[Element]-->[Element]-->[Element]--> null
//! \endverbatim

class InnerNLinkListNode	//! InnerNLinkListNode
  : public InnerListNode
{
  InnerNLinkListNode* next;

 public:
  InnerNLinkListNode(InnerNLinkListNode* next = 0)
  { InnerNLinkListNode::next = next; }
  virtual ~InnerNLinkListNode() { ; }
  InnerNLinkListNode* getNext_() const { return next; }
  void setNext_(InnerNLinkListNode* n) { next = n; }
  void unlink() { next = 0; }
};

class InnerNLinkList		//! InnerNLinkList
  : public InnerList
{
  InnerNLinkListNode* top;
  bool delete_node_p;

 protected:
  void setTop(InnerNLinkListNode* t) { top = t; }

 public:
  InnerNLinkListNode* getTop() const { return top; }

  InnerNLinkList(bool delete_node_p_);
  ~InnerNLinkList();

  bool deleteNodeP() const { return delete_node_p; }
  void setDeleteNodeP(bool p) { delete_node_p = p; }

  bool emptyP() const { return top == 0; }
  Size number() const;
  void clear();
  InnerNLinkListNode* access(Size n) const;
  Size getPosition(InnerNLinkListNode* element) const;

  InnerNLinkListNode* prev(InnerNLinkListNode* node) const;
  InnerNLinkListNode* next(InnerNLinkListNode* node) const
  { return (node != 0) ? node->getNext_() : 0; }
  InnerNLinkListNode* head() const { return top; }
  InnerNLinkListNode* tail() const;
  bool elementP(InnerNLinkListNode* node) const;

  void push(InnerNLinkListNode* node);
  void push(InnerNLinkList& list);
  InnerNLinkListNode* pop();
  void inject(InnerNLinkListNode* node);
  void inject(InnerNLinkList& list);
  InnerNLinkListNode* eject();

  bool insertBefore(Size pos, InnerNLinkListNode* node);
  bool insertBefore(InnerNLinkListNode* pos,
		    InnerNLinkListNode* node);
  bool insertAfter(Size pos, InnerNLinkListNode* node);
  bool insertAfter(InnerNLinkListNode* pos,
		   InnerNLinkListNode* node);
  bool remove(InnerNLinkListNode* node);
  bool remove(Size pos);
  bool exchangeElement(InnerNLinkListNode* pos,
		       InnerNLinkListNode* node);
  bool exchangeElement(Size pos, InnerNLinkListNode* node);
  bool swapElement(InnerNLinkListNode* i1,
		   InnerNLinkListNode* i2);
  bool swapElement(Size n1, Size n2);

  bool removeAllBefore(Size pos);
  bool removeAllBefore(InnerNLinkListNode* pos);
  bool removeAllAfter(Size pos);
  bool removeAllAfter(InnerNLinkListNode* pos);
  bool removeAllBetween(Size pos1, Size pos2);
  bool removeAllBetween(InnerNLinkListNode* pos1,
			InnerNLinkListNode* pos2);

 private:
  bool removeAllBetweenX(InnerNLinkListNode* rm_beg,
			 InnerNLinkListNode* rm_end);
  bool swapElement(InnerNLinkListNode* i1,
		   InnerNLinkListNode* i2,
		   InnerNLinkListNode* i1_prev,
		   InnerNLinkListNode* i2_prev);
};

class InnerNLinkListIterator	//! InnerNLinkListIterator
  : public InnerIterator
{
  InnerNLinkListNode* node;

 private:
  InnerNLinkList* getInnerNLinkList() const
  { return (InnerNLinkList*)getInnerList(); }
  InnerNLinkListNode* getFirst() const
  { return getInnerNLinkList()->getTop(); }
  InnerNLinkListNode* getLast() const;

 public:
  InnerNLinkListIterator(const InnerNLinkList* l);
  InnerNLinkListNode* current() const;
  InnerNLinkListNode* next();
  InnerNLinkListNode* prev();
  InnerNLinkListNode* rewind();
  InnerNLinkListNode* unwind();
  bool validPositionP() const;
  Size getPosition() const; // valid position: return >= 1
};

/*!
 * \brief NLinkListNode
 *
 * CAUTION: class Element must be derived from NLinkListNode
 */
template <class Element>
class NLinkListNode
  : public InnerNLinkListNode
{
 public:
  NLinkListNode(Element* next = 0)
    : InnerNLinkListNode((InnerNLinkListNode*)((NLinkListNode<Element>*)next))
  { ; }
  virtual ~NLinkListNode() { ; }
  Element* getNext() const
  { return (Element*)((NLinkListNode<Element>*)InnerNLinkListNode::getNext_());  }
  void setNext(Element* next)
  { InnerNLinkListNode::setNext_((InnerNLinkListNode*)((NLinkListNode<Element>*)next)); }
};

template <class Element>
class NLinkList			//! NLinkList
  : public List<Element>
{
  InnerNLinkList inll;

 public:
  const InnerNLinkList* getInnerNLinkList() const { return &inll; }

  NLinkList(bool delete_node_p = false) : inll(delete_node_p) { }
  virtual ~NLinkList() { };

#ifdef HAS_STATIC_CAST
#define INNER_NODE_CAST(X) static_cast<InnerNLinkListNode*>(X)
#else /* HAS_STATIC_CAST */
#define INNER_NODE_CAST(X) (InnerNLinkListNode*)(X)
#endif /* HAS_STATIC_CAST */

  // Collection interface
  virtual bool emptyP() const { return inll.emptyP(); }
  virtual Size number() const { return inll.number(); }
  virtual bool add(Element* element) { inll.inject(INNER_NODE_CAST(element)); return true; }
  virtual void clear() { inll.clear(); }
  virtual bool elementP(Element* element) const { return inll.elementP(INNER_NODE_CAST(element)); }
  virtual Iterator<Element>* createIterator() const;

  // List interface
  //void assign(NLinkList& l) { inll.assign(l.inll); }
  void operator = (NLinkList& l) { assign(l); };
  virtual Element* vector(Size vec_pos) const { return (Element*)inll.access(vec_pos + 1); }
  virtual Size getPosition(Element* element) const { return inll.getPosition(INNER_NODE_CAST(element)); }
  virtual Element* prev(Element* element) const { return (Element*)inll.prev(INNER_NODE_CAST(element)); }
  virtual Element* next(Element* element) const { return (Element*)inll.next(INNER_NODE_CAST(element)); }
  virtual Element* head() const { return (Element*)inll.head(); }
  virtual Element* tail() const { return (Element*)inll.tail(); }
  // single element operations
  virtual void push(Element* element) { inll.push(INNER_NODE_CAST(element)); }
  virtual Element* pop() { return (Element*)inll.pop(); }
  virtual void inject(Element* element) { inll.inject(INNER_NODE_CAST(element)); }
  virtual Element* eject() { return (Element*)inll.eject(); }
  virtual bool insertBefore(Size pos, Element* element) { return inll.insertBefore(pos, INNER_NODE_CAST(element)); }
  virtual bool insertBefore(Element* pos, Element* element) { return inll.insertBefore(INNER_NODE_CAST(pos), INNER_NODE_CAST(element)); }
  virtual bool insertAfter(Size pos, Element* element) { return inll.insertAfter(pos, INNER_NODE_CAST(element)); }
  virtual bool insertAfter(Element* pos, Element* element) { return inll.insertAfter(INNER_NODE_CAST(pos), INNER_NODE_CAST(element)); }
  virtual bool remove(Element* pos) { return inll.remove(INNER_NODE_CAST(pos)); }
  virtual bool remove(Size pos) { return inll.remove(pos); }
  virtual bool exchangeElement(Size pos, Element* element) { return inll.exchangeElement(pos, INNER_NODE_CAST(element)); }
  virtual bool exchangeElement(Element* pos, Element* element) { return inll.exchangeElement(INNER_NODE_CAST(pos), INNER_NODE_CAST(element)); }
  virtual bool swapElement(Element* i1, Element* i2) { return inll.swapElement(INNER_NODE_CAST(i1), INNER_NODE_CAST(i2)); }
  virtual bool swapElement(Size n1, Size n2){ return inll.swapElement(n1, n2); }
  virtual bool removeAllBefore(Size pos) { return inll.removeAllBefore(pos); }
  virtual bool removeAllBefore(Element* pos) { return inll.removeAllBefore(INNER_NODE_CAST(pos)); }
  virtual bool removeAllAfter(Size pos) { return inll.removeAllAfter(pos); }
  virtual bool removeAllAfter(Element* pos) { return inll.removeAllAfter(INNER_NODE_CAST(pos)); }
  virtual bool removeAllBetween(Size pos1, Size pos2) { return inll.removeAllBetween(pos1, pos2); }
  virtual bool removeAllBetween(Element* pos1, Element* pos2) { return inll.removeAllBetween(INNER_NODE_CAST(pos1), INNER_NODE_CAST(pos2)); }

  // MISC
  void setDeleteNodeP(bool p) { inll.setDeleteNodeP(p); }
#undef INNER_NODE_CAST

};

template <class Element>
class NLinkListIterator
  : public Iterator<Element>
{
  InnerNLinkListIterator inli;

 public:
  NLinkListIterator(const InnerNLinkList* l) : inli(l) { }
  NLinkListIterator(const InnerNLinkList& l) : inli(&l) { }
  NLinkListIterator(const NLinkList<Element>* l) : inli(l->getInnerNLinkList()) { }
  NLinkListIterator(const NLinkList<Element>& l) : inli(l.getInnerLinkList()) { }
  ~NLinkListIterator() { }
  Element* current() const { return (Element*)inli.current(); }
  Element* next() { return (Element*)inli.next(); }
  Element* prev() { return (Element*)inli.prev(); }
  Element* rewind() { return (Element*)inli.rewind(); }
  Element* unwind() { return (Element*)inli.unwind(); }
  bool validPositionP() const { return inli.validPositionP(); }
  Size getPosition() const { return inli.getPosition(); }
};

template <class Element>
Iterator<Element>*
NLinkList<Element>::createIterator() const
{
  return new NLinkListIterator<Element>(this);
}

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_NLinkList_h */
