﻿// $Id$

#ifndef INCLUDE_ccc_base_NullOFlow_h
#define INCLUDE_ccc_base_NullOFlow_h

#include <ccc/base/OFlow.h>

CCC_NAMESPACE_START(CCC)

/*!
 * どこにもデータを出力しない出力フローです。
 */
class NullOFlow
  : public OFlow
{
 public:
  /*!
   * \ja
   * コンストラクタ
   * \ja_end
   */
  NullOFlow(IOType io_type = IOTYPE_NULL);
  /*!
   * \ja
   * デストラクタ
   * \ja_end
   */
  virtual ~NullOFlow();
  /*!
   * \ja
   * Int8のデータを出力します。
   * \param c 出力するデータ
   * \exception IOException
   * \ja_end
   */
  virtual void putInt8(Int8 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * UInt16 のデータを出力します。
   * \param c 出力するデータ
   * \exception IOException
   * \ja_end
   */
  virtual void putUInt16(UInt16 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * UInt32 のデータを出力します。
   * \param c 出力するデータ
   * \exception IOException
   * \ja_end
   */
  virtual void putUInt32(UInt32 c) CCC_RAISES(IOException);
};

/*!
 * \ja
 * 仮想出力フロー
 * \ja_end
 */
extern NullOFlow* nulout_flow;

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_NullOFlow_h */
