﻿// $Id$

#include <ccc/base/OFilter.h>

CCC_NAMESPACE_START(CCC)

// ------------------------------------------------------------------------
// class OFilter

OFilter::OFilter(IOType my_io_type, IOType dest_io_type, OFlow* dest_)
  : OFlow(my_io_type), dest(dest_)
{
  OFilter::dest_io_type = dest_io_type;
  setOpened(!!dest);
}

OFilter::~OFilter()
{
}
    
void
OFilter::setDest(OFlow* dest_)
{
  dest = dest_;
  setOpened(!!dest);
}

IOType
OFilter::getDestCombinationIOType()
{
  if (openedP())
  {
    return (IOType)(dest->getIOType() & dest_io_type);
  }
  return IOTYPE_NULL;
}

bool
OFilter::close()
{
  if (!openedP())
  {
    return false;
  }
  dest = 0;
  return true;
}

bool
OFilter::openedP()
{
  return !!dest;
}

bool
OFilter::rewind()
{
  if (!openedP())
  {
    return false;
  }
  Flow::rewind();
  return dest->rewind();
}

bool
OFilter::topP()
{
  return Flow::topP();
}

void
OFilter::flush() CCC_RAISES(IOException)
{
  if (!dest)
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_DEST);
  }
  dest->flush();
}

bool
OFilter::validCombinationP()
{
  if (getDestCombinationIOType() == IOTYPE_NULL)
  {
    return false;
  }
  if (!dest)
  {
    return false;
  }
  return dest->validCombinationP();
}

void
OFilter::putInt8(Int8 c) CCC_RAISES(IOException)
{
  if (!dest)
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_DEST);
  }
  dest->putInt8(c);
  setTopP(false);
}

void
OFilter::putUInt16(UInt16 c) CCC_RAISES(IOException)
{
  if (!dest)
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_DEST);
  }
  dest->putUInt16(c);
  setTopP(false);
}

void
OFilter::putUInt32(UInt32 c) CCC_RAISES(IOException)
{
  if (!dest)
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_DEST);
  }
  dest->putUInt32(c);
  setTopP(false);
}

void
OFilter::putInt8Block(Size block_size, const Int8* ptr, Size& put_size) CCC_RAISES(IOException)
{
  if (!dest)
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_DEST);
  }
  dest->putInt8Block(block_size, ptr, put_size);
  setTopP(false);
}

void
OFilter::putUInt16Block(Size block_size, const UInt16* ptr, Size& put_size) CCC_RAISES(IOException)
{
  if (!dest)
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_DEST);
  }
  dest->putUInt16Block(block_size, ptr, put_size);
  setTopP(false);
}

void
OFilter::putUInt32Block(Size block_size, const UInt32* ptr, Size& put_size) CCC_RAISES(IOException)
{
  if (!dest)
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_DEST);
  }
  dest->putUInt32Block(block_size, ptr, put_size);
  setTopP(false);
}

CCC_NAMESPACE_END(CCC)
