﻿// $Id$

#include <ccc/base/OFlow.h>
#include <ccc/base/cstring.h>

CCC_NAMESPACE_START(CCC);

OFlow::OFlow(IOType io_type)
  : Flow(io_type)
{
}

OFlow::~OFlow()
{
}

void
OFlow::flush() CCC_RAISES(IOException)
{
}

void	
OFlow::putInt8(Int8 c) CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
}

void
OFlow::putUInt16(UInt16 c) CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
}

void
OFlow::putUInt32(UInt32 c) CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
}

void
OFlow::putInt8Block(Size block_size, const Int8* ptr, Size& put_size) CCC_RAISES(IOException)
{
  Size n;
  put_size = 0;
  for (n = 0; n < block_size; n++)
  {
    putInt8(*ptr++);
    put_size++;
  }
}

void
OFlow::putUInt16Block(Size block_size, const UInt16* ptr, Size& put_size) CCC_RAISES(IOException)
{
  Size n;
  put_size = 0;
  for (n = 0; n < block_size; n++)
  {
    putUInt16(*ptr++);
    put_size++;
  }
}

void
OFlow::putUInt32Block(Size block_size, const UInt32* ptr, Size& put_size) CCC_RAISES(IOException)
{
  Size n;
  put_size = 0;
  for (n = 0; n < block_size; n++)
  {
    putUInt32(*ptr++);
    put_size++;
  }
}

bool
OFlow::put(const CCC::BString* s)
{
  Size n;
  putInt8Block(s->getLength(), s->getStartPtr(), n);
  return s->getLength() == n;
}

bool
OFlow::put(const CCC::DString* s)
{
  Size n;
  putUInt16Block(s->getLength(), s->getStartPtr(), n);
  return s->getLength() == n;
}

bool
OFlow::put(const CCC::WString* s)
{
  Size n;
  putUInt32Block(s->getLength(), s->getStartPtr(), n);
  return s->getLength() == n;
}

bool
OFlow::put(const Int8* s)
{
  Size s_len = strLen(s);
  Size n;
  putInt8Block(s_len, s, n);
  return s_len == n;
}

bool
OFlow::put(const UInt16* s)
{
  Size s_len = strLen(s);
  Size n;
  putUInt16Block(s_len, s, n);
  return s_len == n;
}

bool
OFlow::put(const UInt32* s)
{
  Size s_len = strLen(s);
  Size n;
  putUInt32Block(s_len, s, n);
  return s_len == n;
}

CCC_NAMESPACE_END(CCC);
