﻿// $Id$

#ifndef INCLUDE_ccc_base_OFlow_h
#define INCLUDE_ccc_base_OFlow_h

#include <ccc/base/Flow.h>
#include <ccc/base/TString.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * 出力用フローの基本クラスです。
 * \ja_end
 */
class OFlow
  : public Flow
{
 public:
  /*!
   * \ja
   * コンストラクタ
   * \ja_end
   */
  OFlow(IOType io_type = IOTYPE_NULL);
  /*!
   * \ja
   * デストラクタ
   * \ja_end
   */
  virtual ~OFlow() = 0;
  /*!
   * \ja
   * バッファリング中のデータを出力に完全に書出しフラッシュします。
   * \ja_end
   */
  virtual void flush() CCC_RAISES(IOException);
  /*!
   * \ja
   * Int8のデータを出力します。
   * \param c 出力するデータ
   * \exception IOException
   * \ja_end
   */
  virtual void putInt8(Int8 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * UInt16 のデータを出力します。
   * \param c 出力するデータ
   * \exception IOException
   * \ja_end
   */
  virtual void putUInt16(UInt16 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * UInt32 のデータを出力します。
   * \param c 出力するデータ
   * \exception IOException
   * \ja_end
   */
  virtual void putUInt32(UInt32 c) CCC_RAISES(IOException);
  /*!
   * \ja
   * Int8のデータブロックを出力します。
   * put_sizeに出力したデータ数がセットされます。
   * \param block_size ブロックサイズ
   * \param ptr データの送り元
   * \param put_size 出力したデータ数
   * \ja_end
   */
  virtual void putInt8Block(Size block_size, const Int8* ptr, Size& put_size) CCC_RAISES(IOException);
  /*!
   * \ja
   * UInt16のデータブロックを出力します。
   * put_sizeに出力したデータ数がセットされます。
   * \param block_size ブロックサイズ
   * \param ptr データの送り元
   * \param put_size 出力したデータ数
   * \ja_end
   */
  virtual void putUInt16Block(Size block_size, const UInt16* ptr, Size& put_size) CCC_RAISES(IOException);
  /*!
   * \ja
   * UInt32のデータブロックを出力します。
   * put_sizeに出力したデータ数がセットされます。
   * \param block_size ブロックサイズ
   * \param ptr データの送り元
   * \param put_size 出力したデータ数
   * \ja_end
   */
  virtual void putUInt32Block(Size block_size, const UInt32* ptr, Size& put_size) CCC_RAISES(IOException);
  /*!
   * 文字列を出力します。
   * \param s 出力する文字列
   * \retval true 正常に出力できました。
   * \retval false 全ての文字を出力できませんでした。
   */
  virtual bool put(const CCC::BString* s);
  /*!
   * 文字列を出力します。
   * \param s 出力する文字列
   * \retval true 正常に出力できました。
   * \retval false 全ての文字を出力できませんでした。
   */
  virtual bool put(const CCC::DString* s);
  /*!
   * 文字列を出力します。
   * \param s 出力する文字列
   * \retval true 正常に出力できました。
   * \retval false 全ての文字を出力できませんでした。
   */
  virtual bool put(const CCC::WString* s);
  /*!
   * 文字列を出力します。
   * \param s 出力する文字列
   * \retval true 正常に出力できました。
   * \retval false 全ての文字を出力できませんでした。
   */
  virtual bool put(const Int8* s);
  /*!
   * 文字列を出力します。
   * \param s 出力する文字列
   * \retval true 正常に出力できました。
   * \retval false 全ての文字を出力できませんでした。
   */
  virtual bool put(const UInt16* s);
  /*!
   * 文字列を出力します。
   * \param s 出力する文字列
   * \retval true 正常に出力できました。
   * \retval false 全ての文字を出力できませんでした。
   */
  virtual bool put(const UInt32* s);
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_OFlow_h */
