﻿// $Id$

#include <string.h>
#include <ccc/base/PushbackIFilter.h>

CCC_NAMESPACE_START(CCC)

template <typename T>
void
PushbackIFilter<T>::clear()
{
  queued_length = 0;
}

template <typename T>
Size
PushbackIFilter<T>::getQueueLength()
{
  return queued_length;
}

template <typename T>
T
PushbackIFilter<T>::pop() 
{
  return buf[--queued_length];
}

template <typename T>
PushbackIFilter<T>::PushbackIFilter(IFlow* src)
  : TIFilter<T>(ioTypeVal<T>(), src)
{
  const Size alloc_size = 16;
  buf = new T[alloc_size];
  buf_size = alloc_size;
  queued_length = 0;
  clear();
}

template <typename T>
PushbackIFilter<T>::~PushbackIFilter()
{
  delete buf;
}

template <typename T>
bool
PushbackIFilter<T>::rewind()
{
  clear();
  return IFilter::rewind();
}

template <typename T>
void
PushbackIFilter<T>::push(T c)
{
  if (queued_length == buf_size)
  {
    T* new_buf = new T[buf_size * 2];
    memcpy(new_buf, buf, buf_size * sizeof(T));
    delete buf;
    buf = new_buf;
    buf_size *= 2;
  }
  buf[queued_length++] = c;
}

template <typename T>
T
PushbackIFilter<T>::getChar() CCC_RAISES(IOException)
{
  if (!TIFilter<T>::openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_SRC);
  }
  if (getQueueLength() > 0)
  {
    return pop();
  }
  return TIFilter<T>::getChar();
}

template <>
Int8
PushbackIFilter<Int8>::getInt8() CCC_RAISES(IOException)
{
  if (!openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_SRC);
  }
  if (getQueueLength() > 0)
  {
    return pop();
  }
  return IFilter::getInt8();
}

template <>
UInt16
PushbackIFilter<UInt16>::getUInt16() CCC_RAISES(IOException)
{
  if (!openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_SRC);
  }
  if (getQueueLength() > 0)
  {
    return pop();
  }
  return IFilter::getUInt16();
}

template <>
UInt32
PushbackIFilter<UInt32>::getUInt32() CCC_RAISES(IOException)
{
  if (!openedP())
  {
    throw IOException(__FILE__, __LINE__, IOException::EMPTY_FILTER_SRC);
  }
  if (getQueueLength() > 0)
  {
    return pop();
  }
  return IFilter::getUInt32();
}

template <typename T>
Int8
PushbackIFilter<T>::getInt8() CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
  return 0;
}

template <typename T>
UInt16
PushbackIFilter<T>::getUInt16() CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
  return 0;
}

template <typename T>
UInt32
PushbackIFilter<T>::getUInt32() CCC_RAISES(IOException)
{
  throw IOException(__FILE__, __LINE__, IOException::NOT_SUPPORTED);
  return 0;
}

template class PushbackIFilter<Int8>;
template class PushbackIFilter<UInt16>;
template class PushbackIFilter<UInt32>;

CCC_NAMESPACE_END(CCC)
