﻿// $Id$

#ifndef INCLUDE_ccc_base_PushbackIFilter_h
#define INCLUDE_ccc_base_PushbackIFilter_h

#include <ccc/base/TIFilter.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * T型の値を差戻す機能を実現するIFilterクラスです。
 * テンプレート引数TはInt8, UInt16, UInt32のいずれかの型のみを
 * サポートします。
 * \ja_end
 */
template <typename T>
class PushbackIFilter
  : public TIFilter<T>
{
  T* buf;
  Size buf_size;
  Size queued_length;

 private:
  void clear();

 protected:
  /*!
   * 読み出していないキューデータの長さ
   */
  Size getQueueLength();
  T pop();

 public:
  /*!
   * \ja
   * コンストラクタ
   * \param src フィルタ元IFlow
   * \ja_end
   */
  PushbackIFilter(IFlow* src = 0);
  /*!
   * \ja
   * デストラクタ
   * \ja_end
   */
  virtual ~PushbackIFilter();
  /*!
   * \ja
   * Flowのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual bool rewind();
  /*!
   * \ja
   * 差し戻しを行います。回数に制限はありません。
   * 差し戻したデータは、次のget*()のメソッドにより取り出せます。
   * \param c 差し戻しデータ
   * \ja_end
   */
  virtual void push(T c);
  /*!
   * \ja
   * TIFilterクラスのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual T getChar() CCC_RAISES(IOException);
  /*!
   * \ja
   * IFlowクラスのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual Int8 getInt8() CCC_RAISES(IOException);
  /*!
   * \ja
   * IFlowクラスのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  /*!
   * \ja
   * IFlowクラスのドキュメントを参照して下さい。
   * \ja_end
   */
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
};

typedef PushbackIFilter<Int8> Int8PushbackIFilter;
typedef PushbackIFilter<UInt16> UInt16PushbackIFilter;
typedef PushbackIFilter<UInt32> UInt32PushbackIFilter;

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_PushbackIFilter_h */
