﻿// $Id$

#ifndef INCLUDE_ccc_base_RandIFlow_h
#define INCLUDE_ccc_base_RandIFlow_h

#include <ccc/base/IFlow.h>

CCC_NAMESPACE_START(CCC)

/*!
 * ランダムな値が返る入力フローです。
 */
class RandIFlow
  : public IFlow
{
 public:
  /*!
   * \ja
   * コンストラクタ
   * \param seed 乱数の種
   * \param io_type サポートする型
   * \ja_end
   */
  RandIFlow(unsigned int seed = 0, IOType io_type = IOTYPE_NULL);
  /*!
   * \ja
   * デストラクタ
   * \ja_end
   */
  virtual ~RandIFlow();
  /*!
   * \ja
   * Int8のデータを取り出します。
   * \return 取り出した値
   * \exception IOException
   * \ja_end
   */
  virtual Int8 getInt8() CCC_RAISES(IOException);
  /*!
   * \ja
   * UInt16のデータを取り出します。
   * \return 取り出した値
   * \exception IOException
   * \ja_end
   */
  virtual UInt16 getUInt16() CCC_RAISES(IOException);
  /*!
   * \ja
   * UInt32 のデータを取り出します。
   * \return 取り出した値
   * \exception IOException
   * \ja_end
   */
  virtual UInt32 getUInt32() CCC_RAISES(IOException);
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_RandIFlow_h */
