﻿// $Id$

#ifndef INCLUDE_ccc_base_SPtr_h
#define INCLUDE_ccc_base_SPtr_h

#include <ccc/base/base.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * スマートポインタクラス
 * このスマートポインタクラスのインスタンスを使用することで、
 * 管理対象のオブジェクトの生存期間を、インスタンスの生存期間に
 * 同期させることができます。
 * \ja_end
 */
template <class T>
class SPtr
{
  /*!
   * \ja
   * 管理対象のオブジェクト
   * \ja_end
   */
  T* p;
 public:
  /*!
   * \ja
   * コンストラクタ
   * \param p 管理対象のオブジェクト
   * \ja_end
   */
  SPtr(T* p)
  {
    SPtr::p = p;
  }
  /*!
   * \ja
   * コピーコンストラクタ
   * 注意: 管理対象オブジェクトのコピーコンストラクタを
   * 呼び出して新しいインスタンスを生成します。
   * \ja_end
   */
  SPtr(SPtr& s)
  {
    SPtr::p = new T(*(s.get()));
  }
  /*!
   * \ja
   * デストラクタ
   * \ja_end
   */
  ~SPtr()
  {
    delete p;
  }
  /*!
   * \ja
   * 管理対象のオブジェクトを取り出します。
   * \ja_end
   */
  T* get() { return p; }
  /*!
   * \ja
   * 管理対象のオブジェクトを取り出します。
   * \ja_end
   */
  T* ref() { return p; }
  /*!
   * \ja
   * 管理対象のオブジェクトを取り出します。
   * \ja_end
   */
  T* operator ->() { return p; }
};

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_SPtr_h */
