﻿// $Id$

#ifndef INCLUDE_ccc_base_Set_h
#define INCLUDE_ccc_base_Set_h

/*!
 * \file set.h
 * \ja
 * このファイルはSetクラスを定義しています。
 * \ja_end
 */

#include <ccc/base/Collection.h>

CCC_NAMESPACE_START(CCC)

/*!
 * \ja
 * SetクラスはCollectionクラスに集合同士の演算機能を加えた仮想インターフェースです。
 * また、SetはElementの重複を許さないという点がCollectionと異なります。
 * \ja_end
 */ 
template <class Element>
class Set
  : public Collection<Element>
{
 public:
  /*!
   * \ja
   * コンストラクタ
   * \ja_end
   */
  Set() { }
  /*!
   * \ja
   * デストラクタ
   * \ja_end
   */
  virtual ~Set() { }
  /*
   * \ja
   * Collectionインターフェース、Collectionクラスの定義を参照のこと。
   * \ja_end
   * \en
   * Collection interfaces, See Collection class definition.
   * \en_end
   */
  virtual bool emptyP() const = 0;
  virtual Size number() const = 0;
  virtual bool add(Element* element) = 0;
  virtual bool remove(Element* element) = 0;
  virtual void clear() = 0;
  virtual bool elementP(Element* element) const = 0;
  virtual Iterator<Element>* createIterator() const = 0;

  /*
   * \ja
   * 集合インターフェース
   * \ja_end
   * \en
   * Set interface
   * \en_end
   */
  
  /*!
   * \ja
   * 与えられた集合に含まれる要素を、この集合から削除します。
   * \param s 削除候補の入った集合
   * \retval true すべての削除候補が削除できた。
   * \retval false 削除候補に削除できないものがあった。
   * \ja_end
   */
  virtual bool remove(Set* s);
  /*!
   * \ja
   * 与えられた集合に含まれる要素を、この集合に加えます。
   * \param s 追加要素の入った集合
   * \retval true すべての要素が追加できた。
   * \retval false 追加要素に追加できないものがあった。
   * \ja_end
   */
  virtual bool add(Set* s);

  /* TODO: */
  /* ユニオン, 和, 排他等の演算の実装 */
};

template <class Element>
bool
Set<Element>::remove(Set* s)
{
  bool ret = true;
  Iterator<Element>* itr = s->createIterator();
  while (itr->validPositionP())
  {
    Element* element = itr->next();
    if (!remove(element))
    {
      ret = false;
    }
  }
  delete itr;
  return ret;
}

template <class Element>
bool
Set<Element>::add(Set* s)
{
  bool ret = true;
  Iterator<Element>* itr = s->createIterator();
  while (itr->validPositionP())
  {
    Element* element = itr->next();
    if (!add(element))
    {
      ret = false;
    }
  }
  delete itr;
  return ret;
}

CCC_NAMESPACE_END(CCC)

#endif /* INCLUDE_ccc_base_Set_h */
